
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Intermediate form                               }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}


unit BorderSidesRVFrm;

interface

{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, BaseRVFrm, RVScroll, RichView, RVStyle, Buttons, StdCtrls,
  {$IFDEF USERVKSDEVTE}
  te_controls,
  {$ENDIF}
  {$IFDEF USERVTNT}
  TntStdCtrls,
  {$ENDIF}
  RVColorCombo, ComCtrls;

type
  TfrmRVBorderSides = class(TfrmRVBase)
    btnOk: TButton;
    btnCancel: TButton;
    rvs: TRVStyle;
    PageControl1: TPageControl;
    ts1: TTabSheet;
    ts2: TTabSheet;
    gbSample: TGroupBox;
    btnLeft: TSpeedButton;
    btnRight: TSpeedButton;
    btnTop: TSpeedButton;
    btnBottom: TSpeedButton;
    rv: TRichView;
    gbSettings: TGroupBox;
    lblColor: TLabel;
    lblWidth: TLabel;
    cmbColor: TRVColorCombo;
    cmbWidth: TComboBox;
    procedure cmbWidthDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnClick(Sender: TObject);
    procedure cmbColorColorChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    function IsThemeAllowedFor(Component: TComponent): Boolean; override;
    {$ENDIF}
    {$IFDEF USERVKSDEVTE}
    procedure tecmbWidthDrawItem(Control: TWinControl; Canvas: TCanvas; Index: Integer;
    Rect: TRect; State: TOwnerDrawState);
    {$ENDIF}
  public
    { Public declarations }
    _cmbWidth: TControl;
    procedure Localize; override;
  end;

implementation
uses RichViewActions, RVALocalize;

{$R *.dfm}

procedure TfrmRVBorderSides.cmbWidthDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  {$IFDEF USERVTNT}
  RVA_DrawCmbWidthItem(TTntComboBox(_cmbWidth).Canvas, Rect, Index, cmbColor.ChosenColor, State);
  {$ELSE}
  RVA_DrawCmbWidthItem(TComboBox(_cmbWidth).Canvas, Rect, Index, cmbColor.ChosenColor, State);
  {$ENDIF}
end;

procedure TfrmRVBorderSides.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);

   procedure SwitchBtn(btn: TSpeedButton);
   begin
     btn.Down := not btn.Down;
     if Assigned(btn.OnClick) then
       btn.OnClick(btn);
   end;

begin
  if ssCtrl in Shift then
    case Key of
    ord('L'):
      SwitchBtn(btnLeft);
    ord('T'):
      SwitchBtn(btnTop);
    ord('R'):
      SwitchBtn(btnRight);
    ord('B'):
      SwitchBtn(btnBottom);
    end;
end;

procedure TfrmRVBorderSides.btnClick(Sender: TObject);
begin
  if Sender is TSpeedButton then
    TSpeedButton(Sender).Flat := False;
end;

procedure TfrmRVBorderSides.cmbColorColorChange(Sender: TObject);
begin
  inherited;
  _cmbWidth.Invalidate;
end;

procedure TfrmRVBorderSides.Localize;
begin
  inherited;
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
end;

{$IFDEF RVASKINNED}
procedure TfrmRVBorderSides.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl = _cmbWidth then begin
    _cmbWidth := NewControl;
    {$IFDEF USERVKSDEVTE}
    TTeComboBox(_cmbWidth).OnDrawItem := tecmbWidthDrawItem;
    {$ENDIF}
  end;
end;

function TfrmRVBorderSides.IsThemeAllowedFor(Component: TComponent): Boolean;
begin
  if Component is TSpeedButton then
    Result := False
  else
    Result := inherited IsThemeAllowedFor(Component);
end;
{$ENDIF}

{$IFDEF USERVKSDEVTE}
procedure TfrmRVBorderSides.tecmbWidthDrawItem(Control: TWinControl;
  Canvas: TCanvas; Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  RVA_DrawCmbWidthItem(Canvas, Rect, Index, cmbColor.ChosenColor, State);
end;
{$ENDIF}

procedure TfrmRVBorderSides.FormCreate(Sender: TObject);
begin
  _cmbWidth := cmbWidth;
  inherited;
end;

end.
