//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <ShellApi.h>
#pragma hdrstop

#include "Demo5Frm.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TfrmDemo5 *frmDemo5;
//---------------------------------------------------------------------------
__fastcall TfrmDemo5::TfrmDemo5(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void AddWithURLs(UnicodeString s, TRichView* rv, int DefStyle, int UrlStyle)
{
  UnicodeString Before = "";
  int ParaNo = 0;
  if (s=="")
  {
    rv->AddNLWTag("", DefStyle, ParaNo, 0);
    return;
  }
  while (s!="")
  {
    int p = s.Pos(" ");
    if (!p)
      p = s.Length()+1;
	UnicodeString CurrentWord = s.SubString(1, p-1);
	UnicodeString Space = s.SubString(p, 1);
	s = s.SubString(p+1, s.Length());
	if (RVIsURL(CurrentWord) || RVIsEmail(CurrentWord))
	{
	  if (Before!="")
	  {
		rv->AddNLWTag(Before, DefStyle, ParaNo, 0);
		ParaNo = -1;
		Before = "";
	  }
      rv->AddNLWTag(CurrentWord, UrlStyle, ParaNo, 0);
      ParaNo = -1;
      if (Space!="")
        rv->AddNLWTag(Space, DefStyle, -1, 0);
    }
    else
      Before += CurrentWord+Space;
   }
   if (Before!="")
     rv->AddNLWTag(Before, DefStyle, ParaNo, 0);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::FormCreate(TObject *Sender)
{
  pan->ClientHeight = edit->Height;
  edit->SetBounds(0,0,pan->ClientWidth,pan->ClientHeight);
  rv->AddNLWTag("Use right-click menu to freeze scrolling when appending text", 2, 0, 0);
  rv->AddNLWTag("Try quick-copy: selection is copied automatically when done", 2, 0, 0);
  AddWithURLs("You can use URLs and e-mail ( like www.trichview.com )",
    rv, 2, 1);
  rv->Format();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::FormResize(TObject *Sender)
{
   edit->Width = pan->ClientWidth;    
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::editKeyPress(TObject *Sender, wchar_t &Key)
{
  if (Key=='\r')
  {
	AddWithURLs(edit->Text,rv,0,1);
    rv->FormatTail();
    Key = 0;
    edit->Text = "";
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::rvSelect(TObject *Sender)
{
  // Quick-copy
  if (rv->SelectionExists())
  {
    rv->CopyDef();
    rv->Deselect();
    rv->Invalidate();
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::pmPopup(TObject *Sender)
{
  mitFreezescrolling->Checked = ! rv->Options.Contains(rvoScrollToEnd);    
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::mitFreezescrollingClick(TObject *Sender)
{
  if (rv->Options.Contains(rvoScrollToEnd))
    rv->Options >> rvoScrollToEnd;
  else
    rv->Options << rvoScrollToEnd;
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::rvJump(TObject *Sender, int id)
{
  int ItemNo = rv->GetJumpPointItemNo(id);
  UnicodeString s = rv->GetItemTextW(ItemNo);
  if (!RVIsURL(s) && RVIsEmail(s))
	s = "mailto:"+s;
  ShellExecute(Application->Handle, L"open", s.c_str(), NULL, NULL, SW_NORMAL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::FormKeyDown(TObject *Sender, WORD &Key,
    TShiftState Shift)
{
  if (Key==VK_ESCAPE)
     Close();
}
//---------------------------------------------------------------------------
