//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
int TForm1::GetListNo(TCustomRichViewEdit* rve, int ItemNo)
{
  int Level, StartFrom, Result;
  bool Reset;
  rve->GetListMarkerInfo(ItemNo, Result, Level, StartFrom, Reset);
  return Result;
}
//---------------------------------------------------------------------------
// Returns index of bulleted list style. Creates it, if necessary.
int TForm1::CreateBullets()
{
  // 1. Creating desired list style
  TRVListInfo* ListStyle = new TRVListInfo(NULL);
  TRVListLevel* Level = ListStyle->Levels->Add();
  Level->ListType  = rvlstBullet;
  Level->Font->Name = "Symbol";
  Level->Font->Charset = SYMBOL_CHARSET;
  Level->Font->Size  = 12;
  Level->FirstIndent = 0;
  Level->LeftIndent  = 24;
  // 2. Searching for existing style with these properties. Creating it, if not found
  int Result = RVStyle1->ListStyles->FindSuchStyle(ListStyle, true);
  delete ListStyle;
  return Result;
}
//---------------------------------------------------------------------------
int TForm1::CreateNumbering()
{
  int Result = -1;
  // 1. Creating desired list style
  TRVListInfo* ListStyle = new TRVListInfo(NULL);
  TRVListLevel* Level = ListStyle->Levels->Add();
  Level->ListType     = rvlstDecimal;
  Level->Font->Name   = "Arial";
  Level->Font->Size   = 12;
  Level->FirstIndent  = 0;
  Level->LeftIndent   = 24;
  Level->FormatString = "%0:s.";
  // 2. Searching for such style in the selected paragraphs, the paragraph before,
  // and the paragraph after. If found, using it.
  int StartNo, EndNo, a, b;
  TCustomRichViewEdit* rve = RichViewEdit1->TopLevelEditor;
  rve->GetSelectionBounds(StartNo, a, EndNo, b, True);
  if (StartNo<0)
  {
    StartNo = rve->CurItemNo;
    EndNo   = StartNo;
  }
  // ExpandToPara is an undocumented method that changes item range StartNo..EndNo
  // so that it completely includes paragraphs containing StartNo..EndNo
  rve->RVData->ExpandToPara(StartNo, EndNo, StartNo, EndNo);
  if (StartNo>0)
    StartNo--;
  if (EndNo<rve->ItemCount-1)
    EndNo++;
  rve->RVData->ExpandToPara(StartNo, EndNo, StartNo, EndNo);
  for (int i=StartNo; i<=EndNo; i++)
    if (rve->IsParaStart(i) && rve->GetItemStyle(i)==rvsListMarker)
    {
      int ListNo = GetListNo(rve, i);
      if (RVStyle1->ListStyles->Items[ListNo]->IsSimpleEqual(ListStyle, true,true))
      {
        Result = ListNo;
        break;
      }
    }
  // 3. Idea for improving. You can try to reuse existing list style with the
  // given properties, which is not used in the document. If you want to do it,
  // you need to iterate through all items in the document, and check all markers.

  // 4. If not found, creating it
  if (Result<0)
  {
    RVStyle1->ListStyles->Add()->Assign(ListStyle);
    Result = RVStyle1->ListStyles->Count-1;
    RVStyle1->ListStyles->Items[Result]->Standard = false;
  }
  delete ListStyle;
  return Result;
}
//---------------------------------------------------------------------------
// CARET WAS MOVED: updating buttons
void __fastcall TForm1::RichViewEdit1CaretMove(TObject *Sender)
{

  TCustomRichViewEdit* rve = RichViewEdit1->TopLevelEditor;
  int FirstParaItemNo = rve->CurItemNo;
  if (FirstParaItemNo<0) // document is cleared
    return;
  while (!rve->IsParaStart(FirstParaItemNo))
    FirstParaItemNo--;
  if (rve->GetItemStyle(FirstParaItemNo)==rvsListMarker)
  {
    int ListNo = GetListNo(rve, FirstParaItemNo);
    btnBullets->Down   = ! RVStyle1->ListStyles->Items[ListNo]->HasNumbering();
    btnNumbering->Down =   RVStyle1->ListStyles->Items[ListNo]->AllNumbered();
  }
  else
  {
    btnBullets->Down   = false;
    btnNumbering->Down = false;
  }
}
//---------------------------------------------------------------------------
// TOGGLING BULLETS
void __fastcall TForm1::btnBulletsClick(TObject *Sender)
{
  if (!btnBullets->Down)
    RichViewEdit1->RemoveLists(false);
  else
    RichViewEdit1->ApplyListStyle(CreateBullets(),0,0,false,false);
}
//---------------------------------------------------------------------------
// TOGGLING NUMBERING
void __fastcall TForm1::btnNumberingClick(TObject *Sender)
{
  if (!btnNumbering->Down)
    RichViewEdit1->RemoveLists(false);
  else
    RichViewEdit1->ApplyListStyle(CreateNumbering(),0,0,false,false);
}
//---------------------------------------------------------------------------