//---------------------------------------------------------------------------
/*
 Important settings:
  rvoTagsArePChars in RichViewEdit1->Options
*/
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
bool GetFieldLocation(TCustomRVData* RootRVData, const UnicodeString field,
  TCustomRVData* &RVData, int &ItemNo)
{
  for (int i=0; i<RootRVData->ItemCount; i++)
    if (RootRVData->GetItemStyle(i)==rvsTable)
    {
      TRVTableItemInfo* table = (TRVTableItemInfo*)(RootRVData->GetItem(i));
      for (int r=0; r<table->Rows->Count; r++)
        for (int c=0; c<table->Rows->Items[r]->Count; c++)
          if (table->Cells[r][c])
          {
            if (GetFieldLocation(table->Cells[r][c]->GetRVData(), field, RVData, ItemNo))
              return true;
          }

    }
    else if (UnicodeString(PChar(RootRVData->GetItemTag(i))) == field)
    {
      ItemNo = i;
      RVData = RootRVData->GetSourceRVData();
      return true;
    }
  return false;
}
//---------------------------------------------------------------------------
UnicodeString GetFieldValue(TCustomRichView* rv, const UnicodeString field)
{
  int ItemNo;
  TCustomRVData* RVData;
  if (GetFieldLocation(rv->RVData, field, RVData, ItemNo))
    return RVData->GetRVData()->GetItemTextW(ItemNo);
  else
    return "";
}
//---------------------------------------------------------------------------
void SetFieldValue(TCustomRichViewEdit* rv,  const UnicodeString field,
  const UnicodeString value)
{
  int ItemNo;
  TCustomRVData* RVData;
  TWinControl* ctrl;
  bool AutoSelect;
  if (GetFieldLocation(rv->RVData, field, RVData, ItemNo))
  {
    if (RVData->GetRVData()->InheritsFrom(__classid(TRVTableCellData)))
    {
      ctrl = GetParentForm(rv)->ActiveControl;
      RVData->Edit();
      AutoSelect = false;
      if (ctrl && ctrl->InheritsFrom(__classid(TEdit)))
      {
        AutoSelect = ((TEdit*)ctrl)->AutoSelect;
        ((TEdit*)ctrl)->AutoSelect = false;
      }
      GetParentForm(rv)->ActiveControl = ctrl;
      if (ctrl && ctrl->InheritsFrom(__classid(TEdit)))
        ((TEdit*)ctrl)->AutoSelect = AutoSelect;
    }
    if (RVData->GetRVData()->InheritsFrom(__classid(TRVEditRVData)))
      ((TCustomRichViewEdit*)((TRVEditRVData*)(RVData->GetRVData()))->RichView)->SetItemTextEdW(ItemNo, value);
  }
}
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  TRVTableItemInfo* table = new TRVTableItemInfo(1,2,RichViewEdit1->RVData);
  table->Cells[0][0]->Clear();
  table->Cells[0][0]->AddNLWTag("Name: ",0,1,0);
  table->Cells[0][0]->AddNLWTag(Edit1->Text,6,-1, (int)StrNew(L"name"));
  table->Cells[0][1]->Clear();
  table->Cells[0][1]->AddNLWTag("Date: ",0,1,0);
  table->Cells[0][1]->AddNLWTag(Edit2->Text,6,-1, (int)StrNew(L"date"));
  table->BorderWidth     = 1;
  table->CellBorderWidth = 1;
  RichViewEdit1->AddItem("",table);
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
void TForm1::InsertField(const UnicodeString field, const UnicodeString value)
{
  if (GetFieldValue(RichViewEdit1, field)!="")
  {
    Application->MessageBox(L"Field already exists!",L"", 0);
    return;
  }
  int StyleNo = RichViewEdit1->CurTextStyleNo;
  RichViewEdit1->CurTextStyleNo = 6;
  RichViewEdit1->InsertStringTag(value, (int)StrNew(field.w_str()));
  RichViewEdit1->CurTextStyleNo = StyleNo;
  RichViewEdit1->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  InsertField("name", Edit1->Text);	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  InsertField("date", Edit2->Text);	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
  RichViewEdit1->ApplyTextStyle(0);
  RichViewEdit1->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit1Change(TObject *Sender)
{
  if (Freeze)
    return;
  Freeze = true;
  try
  {
    SetFieldValue(RichViewEdit1, "name", Edit1->Text);
  }
  catch(...)
  {
  }
  Freeze = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit2Change(TObject *Sender)
{
  if (Freeze)
    return;
  Freeze = true;
  try
  {
    SetFieldValue(RichViewEdit1, "date", Edit2->Text);
  }
  catch(...)
  {
  }
  Freeze = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1Change(TObject *Sender)
{
  if (Freeze)
    return;
  Freeze = true;
  try
  {
    UnicodeString s = GetFieldValue(RichViewEdit1, "name");
    if (s!="")
      Edit1->Text = s;
    s = GetFieldValue(RichViewEdit1, "date");
    if (s!="")
      Edit2->Text = s;
  }
  catch(...)
  {
  }
  Freeze = false;
}
//---------------------------------------------------------------------------