/*==============================================================================
{ Example: two ways of drawing RichView document onto Canvas                   }
==============================================================================*/
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "WMFCanvasWorkAround.hpp"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma link "RVReport"
#pragma link "PtblRV"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  int i;
  // For Example 1
  RichView1->AddNLATag("This is a line of text",1,1,0);
  for (i=0; i<20; i++)
    RichView1->AddNLATag("This is a line of text",0,0,0);
  RichView1->Format();

  // For Example 2
  RVReportHelper1->RichView->Style = RVStyle1;
  RVReportHelper1->RichView->AddNLATag("This is a line of text",1,1,0);
  for (i=0; i<20; i++)
    RVReportHelper1->RichView->AddNLATag("This is a line of text",0,0,0);
}
//---------------------------------------------------------------------------
#define VERYLARGEVALUE 0xFFFFFFF
// Example 1
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  RichView1->HScrollPos = 0;
  RichView1->VScrollPos = 0;
  RichView1->Deselect();
  RichView1->Invalidate();
  int Width  = RichView1->RVData->DocumentWidth+RichView1->LeftMargin+RichView1->RightMargin;
  int Height = RichView1->RVData->DocumentHeight;

  TMetafile* wmf = new TMetafile;
  wmf->Width  = Width;
  wmf->Height = Height;

  TMetafileCanvas* Canvas = (TMetafileCanvas*)CreateMetafileCanvas(wmf); // from WMFCanvasWorkAround unit
  Canvas->Brush->Color = clWindow;
  Canvas->FillRect(Rect(0,0,Width,Height));
  RichView1->RVData->PaintTo(Canvas, Rect(0,0,VERYLARGEVALUE,VERYLARGEVALUE),
    false, false, false, false, 0, 0);
  delete Canvas;

  Image1->Picture->Graphic = wmf;
  delete wmf;
}
//---------------------------------------------------------------------------
// Example 2
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  int Width = 200;

  RVReportHelper1->Init(this->Canvas, Width);
  while (RVReportHelper1->FormatNextPage(VERYLARGEVALUE));

  TMetafile* wmf = new TMetafile;
  wmf->Width  = Width;
  wmf->Height = RVReportHelper1->EndAt;

  TMetafileCanvas* Canvas = (TMetafileCanvas*)CreateMetafileCanvas(wmf); // from WMFCanvasWorkAround unit
  RVReportHelper1->DrawPage(1, Canvas, true, RVReportHelper1->EndAt);
  delete Canvas;

  Image2->Picture->Graphic = wmf;
  delete wmf;
}
//---------------------------------------------------------------------------
