/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class SplashScreen
extends JFrame
implements Runnable {
    JProgressBar progressBar;
    JProgressBar progressBar2;
    JLabel taskOutput;
    JScrollPane scroller;
    Container c;
    JPanel panel;
    ImagePanel image;
    boolean percent;
    boolean jar;
    boolean inited = false;
    Thread thread;
    int progress = 0;
    int progress2 = 0;
    int numStages;
    JLabel row1;
    JLabel row2;
    JLabel row3;
    JLabel row4;
    JLabel row5;
    boolean substance;
    boolean newBar = false;
    boolean bar2added = false;

    public SplashScreen(String title, int numTotalStages, boolean inJar, boolean showPercent) {
        super(title);
        this.numStages = numTotalStages;
        this.jar = inJar;
        this.percent = showPercent;
        this.inited = true;
        if (this.jar) {
            this.setIconImage(new ImageIcon(this.getClass().getResource("icon.gif")).getImage());
        } else {
            this.setIconImage(new ImageIcon("icon.gif").getImage());
        }
        this.setDefaultCloseOperation(3);
        this.c = this.getContentPane();
        this.c.setFocusable(true);
        this.initBar();
        this.setUndecorated(true);
        this.pack();
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(resolution.getWidth() - this.getPreferredSize().getWidth()) / 2, (int)(resolution.getHeight() - this.getPreferredSize().getHeight()) / 2);
        this.setVisible(true);
        this.toFront();
    }

    void cout(String s) {
        System.out.println(s);
    }

    void showPercent(boolean showIt) {
        if (this.progressBar != null) {
            this.progressBar.setStringPainted(showIt);
        }
    }

    void initBar() {
        int w = 300;
        int h = 150;
        int lineH = this.numStages * 19;
        this.progressBar = new JProgressBar(0, this.numStages);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(this.percent);
        this.progressBar.setPreferredSize(new Dimension(w, 20));
        this.progressBar.setOpaque(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar2 = new JProgressBar(0, 100);
        this.progressBar2.setValue(0);
        this.progressBar2.setStringPainted(this.percent);
        this.progressBar2.setPreferredSize(new Dimension(w, 20));
        this.progressBar2.setOpaque(false);
        this.progressBar2.setBorderPainted(false);
        this.taskOutput = new JLabel("loading");
        this.taskOutput.setOpaque(false);
        this.taskOutput.setForeground(Color.white);
        this.scroller = new JScrollPane(this.taskOutput);
        this.scroller.setPreferredSize(new Dimension(w, lineH));
        this.scroller.setOpaque(false);
        this.scroller.getViewport().setOpaque(false);
        this.scroller.setBorder(null);
        this.image = SplashScreen.containsSubstring(this.getTitle(), "IMDb") ? new ImagePanel("imdb splash.jpg", w, h, this.jar) : new ImagePanel("splash.jpg", w, h, this.jar);
        this.image.setFocusable(true);
        this.c.add(this.image);
    }

    static boolean containsSubstring(String bigString, String sub_String) {
        char[] string = bigString.toLowerCase().toCharArray();
        char[] subString = sub_String.toLowerCase().toCharArray();
        int passedChars = 0;
        boolean lastOK = false;
        boolean passed = false;
        for (int i = 0; i < bigString.length(); ++i) {
            if (string[i] == subString[passedChars]) {
                lastOK = true;
                if (++passedChars != subString.length) continue;
                passed = true;
                i = bigString.length();
                continue;
            }
            lastOK = false;
            passedChars = 0;
        }
        return passed;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Failed to init Look and Feel: " + MovieFinder.getStackTrace((Exception)e));
        }
        int steps = 1250;
        SplashScreen splash = new SplashScreen("test", steps, false, true);
        for (int i = 0; i < steps; ++i) {
            splash.updateProgress("                               starting task " + i);
            SplashScreen.sleep(2);
        }
    }

    static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            System.out.println("cant sleep" + MovieFinder.getStackTrace((Exception)e));
        }
    }

    void reInit(String title, int numOfStages) {
        this.setUndecorated(true);
        this.setTitle(title);
        this.numStages = numOfStages;
        this.progress = 0;
        this.setVisible(true);
        this.toFront();
    }

    public void run() {
        this.update();
    }

    void update() {
        if (!this.newBar) {
            ++this.progress;
            this.progressBar.setValue(this.progress);
            this.repaint();
            if (this.progress > this.numStages) {
                this.dispose();
            }
        } else {
            if (!this.bar2added) {
                this.image.add(this.progressBar2);
                this.image.updateUI();
                this.bar2added = true;
            }
            ++this.progress2;
            this.progressBar2.setValue(this.progress2);
        }
    }

    void updateProgressAddTotal(String update, int stageIncrease) {
        this.numStages += stageIncrease;
        this.progressBar.setMaximum(this.numStages);
        this.taskOutput.setText(update);
        Thread thread = new Thread(this);
        thread.start();
    }

    void updateProgress(String update) {
        if (this.taskOutput != null) {
            this.taskOutput.setText(update);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    void addNewBar() {
        this.newBar = true;
    }

    void updateProgress() {
        Thread thread = new Thread(this);
        thread.start();
    }

    void closeBar2() {
        this.newBar = false;
        this.image.remove(2);
        this.image.updateUI();
    }

    class ImagePanel
    extends JPanel {
        ImageIcon icon;
        String picFile;

        public ImagePanel(String filename, int w, int h, boolean inJar) {
            this.icon = inJar ? new ImageIcon(this.getClass().getResource(filename)) : new ImageIcon(filename);
            this.picFile = filename;
            this.setLayout(new FlowLayout());
            this.setPreferredSize(new Dimension(w + 15, h + 60));
            this.add(SplashScreen.this.progressBar);
            this.add(SplashScreen.this.taskOutput);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.icon.getImage(), 0, 0, this);
        }
    }
}

