unit HimeLib;

{====================================================================
                     Delphi wraper class for:
                       H I M E . d l l
          Huge Integer Math and Encryption library dll
                            V 1.01
                 (C) 2002-2004 DevOTechS
                 e-mail: support@devotechs.com
====================================================================}

interface

const
 hi_ErrBit_Div = 1;
 hi_ErrBit_ModInv = 2;
 hi_ErrBit_GenerateRSAKeys = 4;
 hi_ErrBit_Sub = 8;
 hi_ErrBit_Encrypt_RSA = 16;
 hi_ErrBit_Decrypt_RSA = 32;
 hi_ErrBit_Encrypt_AES_CBC = 64;
 hi_ErrBit_Decrypt_AES_CBC = 128;
 hi_ErrBit_Encrypt_AES_ECB = 256;
 hi_ErrBit_Decrypt_AES_ECB = 512;
 hi_ErrBit_Encrypt_AES_1Block = 1024;
 hi_ErrBit_Decrypt_AES_1Block = 2048;

type
  THugeFormat = (hi_Huge, hi_Dec, hi_Hex, hi_Bin);
  THugeRegister = 0..9;

  THimeLib = class
  private
    function PutReg_(lReg: THugeRegister; RegData: string):integer;
    function FormatHuge_(lReg1, lReg2: THugeRegister; NewFormat: THugeFormat):integer;
  public
    // Register Handling & data conversion
    function PutReg(lReg: THugeRegister; RegData: string; InputFormat: THugeFormat):integer;
    function GetReg(lReg: THugeRegister): string; overload;
    function GetReg(lReg: THugeRegister;Format: THugeFormat): string; overload; // Read Formated
    function FormatHuge(lReg: THugeRegister; NewFormat: THugeFormat):integer; overload;
    function FormatHuge(lReg1, lReg2: THugeRegister; NewFormat: THugeFormat):integer; overload; // Format Copy

    // Basic math functions
    function HugeAdd(lReg1, lReg2, lReg_Result: Integer):integer;
    function HugeSub(lReg1, lReg2, lReg_Result: Integer):integer;
    function HugeDiv(lReg1, lReg2, RegQuot, RegRem: Integer):integer;
    function HugeDivBy2(lReg1, RegQuot, RegRem: Integer):integer;
    function HugeMod(lReg1, lReg2, lReg_Result: Integer): Integer;
    function HugeModInv(lReg1, lReg2, lReg_Result: Integer): Integer;
    function HugeMul(lReg1, lReg2, lReg_Result: Integer): Integer;
    function HugeMulBy2(lReg, lReg_Result: Integer): Integer;
    function HugePow(lReg1, lReg2, lReg_Result: Integer): Integer;
    function HugePowMod(lReg1, lReg2, lReg3, lReg_Result: Integer): Integer;
    function HugeGCD(lReg1, lReg2, lReg_Result: Integer): Integer;

    // Boolean funcions
    function HugeIsEqual(lReg1,lReg2: Integer): Integer;
    function HugeIsNotEqual(lReg1, lReg2: Integer): Integer;
    function HugeIsLess(lReg1, lReg2: Integer): Integer;
    function HugeIsOdd(lReg1: Integer): Integer;
    function HugeIsZero(lReg1: Integer): Integer;

    // Random number functions
    function GenerateRandom(lLengthBits: Longword; lReg_Result: Integer): Integer;
  end;

var
  Hime: THimeLib;


implementation

uses sysutils;

{=====================================================
         Register Handling & data conversion
 =====================================================}

// Register Handling
function HI_PUTREGADD (var lAddress;var lLen: Longword; var LReg: Longword): Longword; stdcall; external 'hime.dll';
function HI_GETREGADD(var lReg: Longword; var lAddress; var lLen:Longword): Longword; stdcall; external 'hime.dll';
function HI_COPYREG (var lRegSource, lRegTarget: Longword): Longword; stdcall; external 'hime.dll';
function HI_SWAPREG(lReg1: Longword; lReg2: Longword): Longword; stdcall; external 'hime.dll';

// Data Conversion
function HI_DEC2HUGE(var lRegIn, lRegOut : Longword): Longword; stdcall; external 'hime.dll';
function HI_HUGE2BIN(var lRegIn, lRegOut : Longword): Longword; stdcall; external 'hime.dll';
function HI_HUGE2HEX(var lRegIn, lRegOut : Longword): Longword; stdcall; external 'hime.dll';
function HI_HUGE2DEC(var lRegIn, lRegOut : Longword): Longword; stdcall; external 'hime.dll';


function THimeLib.PutReg_(lReg: THugeRegister; RegData: string):integer;
var
  Addr: PChar;
  Len: LongWord;
  RegN: LongWord;
begin
  Len:=length(RegData);
  Addr:=@RegData[1];
  RegN:=lReg;
  Result:=HI_PUTREGADD(Addr,Len,RegN);
end;

function THimeLib.PutReg(lReg: THugeRegister; RegData: string; InputFormat: THugeFormat):integer;
var
  RegN: LongWord;
begin
  RegN:=lReg;
  Result:=PutReg_(RegN,RegData);
  case InputFormat of
    hi_Huge: ;// no need for format conversion
    hi_Dec: HI_DEC2HUGE(RegN,RegN);
    hi_Hex: ;// HI_HEX2HUGE(RegN,RegN);
    hi_Bin: ;
  end;
end;

function THimeLib.FormatHuge_(lReg1, lReg2: THugeRegister; NewFormat: THugeFormat):integer;
var
  Reg1, Reg2 : LongWord;
begin
  Reg1:=lReg1; Reg2:=lReg2;
  case NewFormat of
    hi_HUGE: ; // No Format conversion needed;
    hi_Dec: Result:=HI_HUGE2DEC(Reg1,Reg2);
    hi_Hex: Result:=HI_HUGE2HEX(Reg1,Reg2);
    hi_Bin: Result:=HI_HUGE2BIN(Reg1,Reg2);
  end;
end;

function THimeLib.FormatHuge(lReg: THugeRegister; NewFormat: THugeFormat):integer;
begin
  FormatHuge_(lReg,lReg,NewFormat);
end;

function THimeLib.FormatHuge(lReg1,lReg2: THugeRegister; NewFormat: THugeFormat):integer;
begin
  FormatHuge_(lReg1,lReg2,NewFormat);
end;

function THimeLib.GetReg(lReg: THugeRegister): string;
var
  Addr: PChar;
  Len: LongWord;
  RegN: LongWord;
begin
  RegN:=lReg;
  HI_GETREGADD(RegN,Addr,Len);
  Result:=StrPas(Addr)
end;

function THimeLib.GetReg(lReg: THugeRegister; Format: THugeFormat): string;
var
  RegN: LongWord;
begin
  RegN:=lReg;
  FormatHuge(RegN,Format);
  result:=GetReg(RegN)
end;


{=====================================================
                Basic math functions
 =====================================================}

function HI_ADD(var lReg1, lReg2, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_SUB(var lReg1, lReg2, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_DIV(var lReg1, lReg2, lReg_Quot, lReg_Rem: Longword): Longword; stdcall; external 'hime.dll';
function HI_DIVBY2(var lReg1, lReg_Quot, lReg_Rem: Longword): Longword; stdcall; external 'hime.dll';
function HI_MOD(var lReg1, lReg2, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_MODINV(var lReg1, lReg2, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_MUL(var lReg1, lReg2, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_MULBY2(var lReg1, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_POW(var lReg1, lReg2, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_POWMOD(var lReg1, lReg2, lReg3: Longword; lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_GCD(var lReg1, lReg2, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';

function THimeLib.HugeAdd(lReg1, lReg2, lReg_Result: Integer):integer;
var
 Reg1, Reg2, ResReg : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; ResReg:=lReg_Result;
  Result:=HI_ADD(Reg1,Reg2,ResReg);
end;

function THimeLib.HugeSub(lReg1, lReg2, lReg_Result: Integer):integer;
var
 Reg1, Reg2, ResReg : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; ResReg:=lReg_Result;
  Result:=HI_SUB(Reg1,Reg2,ResReg);
end;

function THimeLib.HugeDiv(lReg1, lReg2, RegQuot, RegRem: Integer):integer;
var
 Reg1, Reg2, ResQuot, ResRem : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; ResQuot:=RegQuot; ResRem:=RegRem;
  Result:=HI_DIV(Reg1,Reg2,ResQuot,ResRem);
end;

function THimeLib.HugeDivBy2(lReg1, RegQuot, RegRem: Integer):integer;
var
 Reg1, ResQuot, ResRem : Longword;
begin
  Reg1:=lReg1; ResQuot:=RegQuot; ResRem:=RegRem;
  Result:=HI_DIVBY2(Reg1,ResQuot,ResRem);
end;

function THimeLib.HugeMod(lReg1, lReg2, lReg_Result: Integer): Integer;
var
 Reg1, Reg2, ResReg : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; ResReg:=lReg_Result;
  Result:=HI_MOD(Reg1,Reg2,ResReg);
end;

function THimeLib.HugeModInv(lReg1, lReg2, lReg_Result: Integer): Integer;
var
 Reg1, Reg2, ResReg : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; ResReg:=lReg_Result;
  Result:=HI_MODINV(Reg1,Reg2,ResReg);
end;

function THimeLib.HugeMul(lReg1, lReg2, lReg_Result: Integer): Integer;
var
 Reg1, Reg2, ResReg : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; ResReg:=lReg_Result;
  Result:=HI_MUL(Reg1,Reg2,ResReg);
end;

function THimeLib.HugeMulBy2(lReg, lReg_Result: Integer): Integer;
var
 Reg, ResReg : Longword;
begin
  Reg:=lReg; ResReg:=lReg_Result;
  Result:=HI_MULBY2(Reg,ResReg);
end;

function THimeLib.HugePow(lReg1, lReg2, lReg_Result: Integer): Integer;
var
 Reg1, Reg2, ResReg : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; ResReg:=lReg_Result;
  Result:=HI_POW(Reg1,Reg2,ResReg);
end;

function THimeLib.HugePowMod(lReg1, lReg2, lReg3, lReg_Result: Integer): Integer;
var
 Reg1, Reg2, Reg3, ResReg : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; Reg3:=lReg3; ResReg:=lReg_Result;
  Result:=HI_POWMOD(Reg1,Reg2,Reg3,ResReg);
end;

function THimeLib.HugeGCD(lReg1, lReg2, lReg_Result: Integer): Integer;
var
 Reg1, Reg2, ResReg : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2; ResReg:=lReg_Result;
  Result:=HI_GCD(Reg1,Reg2,ResReg);
end;


{=====================================================
                  Boolean Functions
 =====================================================}

function HI_ISEQUAL(var lReg1, lReg2: Longword): Longword; stdcall; external 'hime.dll';
function HI_ISNOTEQUAL(var lReg1, lReg2: Longword): Longword; stdcall; external 'hime.dll';
function HI_ISLESS(var lReg1, lReg2: Longword): Longword; stdcall; external 'hime.dll';
function HI_ISODD(var lReg1: Longword): Longword; stdcall; external 'hime.dll';
function HI_ISZERO(var lReg1: Longword): Longword; stdcall; external 'hime.dll';

function THimeLib.HugeIsEqual(lReg1,lReg2: Integer): Integer;
var
 Reg1, Reg2 : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2;
  Result:=HI_ISEQUAL(Reg1,Reg2);
end;

function THimeLib.HugeIsNotEqual(lReg1, lReg2: Integer): Integer;
var
 Reg1, Reg2 : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2;
  Result:=HI_ISNOTEQUAL(Reg1,Reg2);
end;

function THimeLib.HugeIsLess(lReg1, lReg2: Integer): Integer;
var
 Reg1, Reg2 : Longword;
begin
  Reg1:=lReg1; Reg2:=lReg2;
  Result:=HI_ISLESS(Reg1,Reg2);
end;

function THimeLib.HugeIsOdd(lReg1: Integer): Integer;
var
 Reg1: Longword;
begin
  Reg1:=lReg1;
  Result:=HI_ISODD(Reg1);
end;

function THimeLib.HugeIsZero(lReg1: Integer): Integer;
var
 Reg1 : Longword;
begin
  Reg1:=lReg1;
  Result:=HI_ISZERO(Reg1);
end;


{=====================================================
                Prime number functions
 =====================================================}

// Prime number functions
function HI_GENERATEPRIME(lLengthBits: Longword; lPrimeTests: Longword; lReg_Result: Longword): Longword; stdcall; external 'hime.dll';
function HI_READPRIMES(lPrimesToRead: Longword): Longword; stdcall; external 'hime.dll';

function HI_ISPRIME_DIV(lReg1: Longword): Longword; stdcall; external 'hime.dll';
function HI_ISPRIME_F(lTests: Longword; lReg1: Longword): Longword; stdcall; external 'hime.dll';
function HI_ISPRIME_RB(lTests: Longword; lReg1: Longword): Longword; stdcall; external 'hime.dll';
function HI_ISPRIME_SLOW(lReg1: Longword): Longword; stdcall; external 'hime.dll';
function HI_ISRELPRIME(lReg1: Longword; lReg2: Longword): Longword; stdcall; external 'hime.dll';


{=====================================================
                Random number functions
 =====================================================}
// Fast PRNG
function HI_GENERATERANDOM(var lLengthBits, lReg_Result: Longword): Longword; stdcall; external 'hime.dll';

function THimeLib.GenerateRandom(lLengthBits: Longword; lReg_Result: Integer): Integer;
var
 Reg, ResReg : Longword;
begin
  Reg:=lLengthBits; ResReg:=lReg_Result;
  Result:=HI_GENERATERANDOM(Reg,ResReg);
end;

// Cryptographically secure PRNG using BBS algorithm
function HI_INITBBS(lBitLength: Longword; lPrimeTests: Longword; lReg_Modul: Longword; lReg_Seed: Longword): Longword; stdcall; external 'hime.dll';
function HI_GENERATEBBSRANDOMBITS(lBytes: Longword; lMultipleBits: Longword; lReg_SSeed: Longword; lReg_Modul: Longword; lReg_Result: Longword; lReg_ESeed: Longword): Longword; stdcall; external 'hime.dll';

// Cryptographically secure PRNG using RSA algorithm
function HI_GENERATERSARANDOMBITS(lBytes: Longword; lReg_SSeed: Longword; lReg_he: Longword; lReg_Modul: Longword; lReg_Result: Longword; lReg_EndSeed: Longword): Longword; stdcall; external 'hime.dll';


{=====================================================
              Encryption/Decryption functions
 =====================================================}

// AES (Rijndael) encryption
function HI_ENCRYPT_AES_1BLOCK(lReg_Plain: Longword; lReg_Key: Longword; lReg_Cipher: Longword): Longword; stdcall; external 'hime.dll';
function HI_ENCRYPT_AES_CBC(lReg_Plain: Longword; lReg_Key: Longword; lReg_IV: Longword; lReg_Cipher: Longword): Longword; stdcall; external 'hime.dll';
function HI_ENCRYPT_AES_ECB(lReg_Plain: Longword; lReg_Key: Longword; lReg_Cipher: Longword): Longword; stdcall; external 'hime.dll';
function HI_DECRYPT_AES_1BLOCK(lReg_Cipher: Longword; lReg_Key: Longword; lReg_Plain: Longword): Longword; stdcall; external 'hime.dll';
function HI_DECRYPT_AES_CBC(lReg_Cipher: Longword; lReg_Key: Longword; lReg_Plain: Longword): Longword; stdcall; external 'hime.dll';
function HI_DECRYPT_AES_ECB(lReg_Cipher: Longword; lReg_Key: Longword; lReg_Plain: Longword): Longword; stdcall; external 'hime.dll';

// RSA encryption
function HI_GENERATERSAKEYS(lBitLength: Longword; lPrimeTests: Longword; lReg_he: Longword; lReg_hd: Longword; lReg_Modul: Longword): Longword; stdcall; external 'hime.dll';
function HI_DECRYPT_RSA(lReg_Cipher: Longword; lReg_hd: Longword; lReg_hModul: Longword; lReg_Plain: Longword): Longword; stdcall; external 'hime.dll';
function HI_ENCRYPT_RSA(lReg_Plain: Longword; lReg_he: Longword; lReg_hModul: Longword; lReg_Cipher: Longword): Longword; stdcall; external 'hime.dll';


{=====================================================
                    Hash functions
 =====================================================}

function HI_HASH_SHA_256(lRegIn: Longword; lRegOut: Longword): Longword; stdcall; external 'hime.dll';


{=====================================================
                  Miscelaneous
 =====================================================}

function HI_CHECKTESTVECTORS_AES(): Longword; stdcall; external 'hime.dll';
function HI_CHECKTESTVECTORS_SHA_256(): Longword; stdcall; external 'hime.dll';

function HI_GETGLOBALERROR(): Longword; stdcall; external 'hime.dll';

// HIME DLL functions
function HI_VERSION(): Longword; stdcall; external 'hime.dll';
function HI_REGISTER(lReg1: Longword): Longword; stdcall; external 'hime.dll';


end.
