/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSPlatform.h
*********************************************************************/

#ifndef VSPlatform_H
#define VSPlatform_H /* Hardware and OS Platform definitions */

#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#ifdef __cplusplus
extern "C"{
#endif

    /* #define VERSYPDF_EXPORT*/
    /* #define VERSYPDF_DLL*/

    /* ==== PLATFORM DEFINE: ========================================================================== */
    /* #define NEXTSTEP_PLATFORM        1 */
    /* #define BSDI_PLATFORM            1 */
    /* #define FreeBSD_PLATFORM         1 */
    /* #define Linux_PLATFORM           1 */
    /* #define SolarisSunCC_PLATFORM    1 */
    /* #define SolarisGCC_PLATFORM      1 */
    /* #define SunOS5x_PLATFORM         1 */
    /* #define MacOS8_PLATFORM          1 */
    /* #define MACOSX_PLATFORM          1 */
    /* #define Cygwin_PLATFORM          1 */
    /* #define AIX_PLATFORM             1 */
    /* #define HPUX_PLATFORM            1 */
    /* #define UNIX_PLATFORM            1 */
    /* #define AS400_PLATFORM           1 */
    /* ================================================================================================ */

#if defined(MACOS) || defined(TARGET_OS_MAC) || defined(__APPLE__)
#define MACOSX_PLATFORM /* MacOS Platform */
#endif

#if (defined __OS2__ || defined __EMX__) && !defined OS2
#define OS2_PLATFORM /* OS2 Platform */
#endif

#ifdef  OS2_PLATFORM
#define READMODE    "rb"   /* Read mode parameters */
#define WRITEMODE   "wb"   /* Write mode parameters */
#define APPENDMODE  "ab"   /* Append mode parameters */
#define PDFPLATFORM "OS/2" /* OS2 Operation System */
#define PDFLITTLEENDIAN 1  /* Little Endian Number Data Store Type*/
#endif  


#ifdef UNIX_PLATFORM
#define PDFPLATFORM "Unix Generic" /* Unix Operation System */
#endif

#ifdef AIX_PLATFORM
#define PDFPLATFORM "AIX" /* AIX Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef HPUX_PLATFORM
#define PDFPLATFORM "HP-UX" /* HP-UX Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef NEXTSTEP_PLATFORM
#define PDFPLATFORM "NEXTSTEP or OPENSTEP" /* NEXTSTEP or OPENSTEP Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef BSDI_PLATFORM
#define PDFPLATFORM "BSDI BSD/OS" /* BSDI BSD/OS Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef SolarisSunCC_PLATFORM
#define PDFPLATFORM "Solaris SunCC" /* Solaris SunCC Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef SolarisGCC_PLATFORM
#define PDFPLATFORM "Solaris GCC" /* Solaris GCC Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef SunOS5x_PLATFORM
#define PDFPLATFORM "SunOS5.x" /* SunOS5.x Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef NetBSD_PLATFORM
#define PDFPLATFORM "NetBSD" /* NetBSD Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef FreeBSD_PLATFORM
#define PDFPLATFORM "FreeBSD" /* FreeBSD Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef Linux_PLATFORM
#define PDFPLATFORM         "Linux" /* Linux Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#endif

#ifdef MACOSX_PLATFORM
#define PDFPLATFORM         "MacOS X" /* MacOS X Operation System */
#define UNIX_PLATFORM 1   /* Unix Platform Type */
#define READMODE    "rb"  /* Read mode parameters */
#define WRITEMODE   "wb"  /* Write mode parameters */
#define APPENDMODE  "ab"  /* Append mode parameters */
#endif

#ifdef __CYGWIN32__
#define PDFPLATFORM "Cygwin" /* Cygwin Operation System */
#define WRITEMODE "wb"       /* Write mode parameters */
#define READMODE "rb"        /* Read mode parameters */
#define APPENDMODE "ab"      /* Append mode parameters */
#define PATH_SEPARATOR '/'   /* Path separator by Unix OS */
#define UNIX_PLATFORM 1      /* Unix Platform Type */
#undef  _WIN32
#endif

#if defined(_WIN32) || defined(WIN32)
#define PDFPLATFORM "Windows 9x/NT/2000/XP" /* Windows 9x/NT/2000/XP Operation System */
#define WINDOWS_PLATFORM    /* Windows platform */
#ifndef PDFLITTLEENDIAN
#define PDFLITTLEENDIAN 1   /* Little Endian Number Data Store Type*/
#endif
#ifndef SWAPBITS
#define SWAPBITS 1          /* Set Swap Bits Option */
#endif
#define READMODE "rb"       /* Read mode parameters */
#define WRITEMODE "wb"      /* Write mode parameters */
#define APPENDMODE "ab"     /* Append mode parameters */
#define PATH_SEPARATOR "\\" /* Path separator by Windows OS */
#endif

#if defined __ILEC400__ && !defined AS400_PLATFORM
#define AS400_PLATFORM      /* AS400 platform */
#endif

#ifdef AS400_PLATFORM
#define WRITEMODE   "wb"    /* Write mode parameters */
#define READMODE    "rb"    /* Read mode parameters */
#define APPENDMODE  "ab"    /* Append mode parameters */
#define PDFPLATFORM "iSeries" /* iSeries Operation System */
#endif

/* Default Values */
#ifndef READMODE
#define READMODE "r" /* Read mode parameters */
#endif

#ifndef WRITEMODE
#define WRITEMODE "w" /* Write mode parameters */
#endif

#ifndef APPENDMODE
#define APPENDMODE "a" /* Append mode parameters */
#endif

#ifndef PATH_SEPARATOR
#define PATH_SEPARATOR "/" /* Path separator by OS */
#endif



#ifdef UNIX_PLATFORM
#if defined(__i386) || defined(__alpha)
#define PDFLITTLEENDIAN 1 /* Little Endian Number Data Store Type*/
#define SWAPBITS 1
#else
#define LITTLE_ENDIAN   0 /* Big Endian Number Data Store Type*/
#endif
#if defined(__alpha)
#define PDFLARGEINT /* Enable Large Integer Definition */
#endif
#endif

#ifdef WINDOWS_PLATFORM
#define LIB_CALL    __cdecl  /* Library calling Type ( ANSI C ) */

#ifdef VERSYPDF_EXPORTS
#define LIB_API __declspec(dllexport) /* PDF Library API Enable */
#elif defined(VERSYPDF_DLL)
#define LIB_API __declspec(dllimport) /* PDF Library API Enable */
#else   
#define LIB_API /* PDF Library API Enable */
#endif  
#else   
#if ((defined __IBMC__ || defined __IBMCPP__) && defined __DLL__ && defined OS2_PLATFORM)
#define LIB_CALL _Export /* PDF Library external calling enable only for exporting data */
#define LIB_API /* PDF Library API Enable */
#endif  

#ifndef LIB_CALL
#define LIB_CALL /* PDF Library external calling Enable */
#endif
#ifndef LIB_API
#define LIB_API /* PDF Library API Enable */
#endif

#endif  

#if defined(__MWERKS__) && defined(VERSYPDF_EXPORTS)
#pragma export on
#endif

#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSPlatform_H */
