/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"
#include "VSAnnotA.h"
#include "VSFontA.h"

int main( void )
{
	int ArialIndex, TimesIndex;      /* Font indexes */
	int Page;                                     /* Page index variable description */
	PBXHandle PB;                                 /* Paint box variable description */ 
	PDFDocHandle doc = NULL;                      /* Document variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocCreate( PDFLibrary );             /* Create new PDF file */
		PDFDocSetAutoLaunch( doc, true );             /* Launch destination PDF file after work */
		Page = PDFDocAppendPage2( doc, psA4,poPagePortrait );  /* Insert new page into document */
		PB = PDFPageCreatePaintBox( doc, Page, 72 );    /* Create paintbox */ 
		ArialIndex = PDFFontAppendTrueTypeFromFile( doc, "../Data/in/ariali.ttf");    /* Load Arial Italic font */
#ifdef WINDOWS_PLATFORM
		TimesIndex = PDFFontAppendTrueType( doc, "Times New Roman", true, true );    /* Load Times Bold Italic font */
#endif
		PBXSetActiveFont( PB, ArialIndex, 14, false, false );                         /* Set Arial Italic as active font */      
		PBXTextOut( PB, 20, 20, 0 , "True type Arial Italic" );                       /* Draw text by current font */
		PBXSetActiveFont( PB, TimesIndex, 14, false, false );                         /* Set Times New Roman Bold Italic as active font */
		PBXTextOut( PB, 20, 35, 0 , "True type Times New Roman Italic bold" );         /* Draw text by current font */
		PBXClose( PB, true );                                     /* Close paintbox */
		PDFDocSaveToFile( doc, "../Data/out/TrueTypeTest.pdf" );      /* Saving the document */ 
	} PDFFINALLY( PDFLibrary ){                                   /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
}
