/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>          /* Use standard Input/Output Console API */

#include "VSLibA.h"         /* Use Versy PDF Library */
#include "VSExcept.h"       /* Use Exceptions API */
#include "VSError.h"        /* Use Errors API */
#include "VSDocA.h"         /* Use PDF Document API */
#include "VSPageA.h"        /* Use PDF Page Document API */

#include "VSAcroObjects.h"  /* Use Acro Objects API */

int main( int argc, char* argv[] ) /* Get PDF filename as first parameter */
{
    PDFLibHandle	PDFLibrary; /* PDF Library Handle */
	PDFDocHandle	Doc = NULL; /* PDF Document Handle */

    TPDFSignature   Signature;  /* Blank Signature Acro Object */
    ppInt32         ErrorCode;  /* Check Error Code */

    PDFLibrary = InitPDFLibrary( NULL, NULL );/* Initialize PDF Library */
    PDFTRY( PDFLibrary )/* On error keep exception */
            Doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf" );/* Load existing PDF file */
            PDFDocSetLinearized( Doc, false ); /* Set non-linearize option for crypted PDF file */

            if ( PDFDocGetPageCount( Doc ) > 0 ) { /* If have one or more pages in source document */
                PDFDocSetAutoLaunch( Doc, true );/* Launch destination PDF file after work */

                Signature.Name = (char *)malloc(255); /* Memory allocation for Digital Signature Name */
                Signature.AnnotFlag = PDFAnnotFlags_Print | PDFAnnotFlags_Locked; /* Set Annotation Flags for Digital Signature */
                Signature.SigFlags = PDFAcroSigFlags_SignaturesExist | PDFAcroSigFlags_AppendOnly; /* Set Signature's Flags for AcroForm */
                sprintf( Signature.Name, "BlankSignature" ); /* Set Digital Signature Name as "BlankSignature" */
                Signature.Border.Rect = PDFPageGetBox( Doc, 0, pbnMediaBox ); /* Check Page Size */
                Signature.Border.Rect.xr = Signature.Border.Rect.xr - 10; /* Set Signature right border on 10 points on the left from page border */
                Signature.Border.Rect.xl = Signature.Border.Rect.xr - 200; /* Set Signature width as 200 points */
                Signature.Border.Rect.yl = Signature.Border.Rect.yl + 10; /* Set Signature bottom border on 10 points on the top from page border */
                Signature.Border.Rect.yr = Signature.Border.Rect.yl + 100; /* Set Signature height as 100 points */
                PDFAcroSignatureInDocument( Doc, 0, Signature ); /* Set Blank Site for Digital Signature to right-bottom corner of the page */
                free( Signature.Name ); /* Free memory of Signature Name */

                PDFDocSaveToFile( Doc, "../Data/out/SetBlankSign.pdf" ); /* Save destination PDF file as "set-blank-sign.pdf" in current path */
            }
    PDFFINALLY( PDFLibrary )/* Do further if haven't PDF Library Exceptions */
		if ( Doc ) PDFDocClose ( Doc );/* Close PDF Document and free memory */
		ErrorCode = PDFLASTERROR( PDFLibrary );/* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary );/* Free PDF Library */
    PDFTRYEND( PDFLibrary );/* End of try...end block */
    return ErrorCode;/* Return Error Code as program result */
}

