/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"

int main( void )
{
	int I;                                        /* Image index variable */
	int Page;                                     /* Page index variable description */
	PBXHandle PB;                                 /* Paint box variable description */ 
	PDFDocHandle doc = NULL;                      /* Document variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocCreate( PDFLibrary );                     /* Create new PDF file */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		Page = PDFDocAppendPage2(doc, psA4, poPagePortrait);  /* Insert new page into document */
		I = PDFDocAppentImageFromPNGFile ( doc, "../Data/in/logo.png",  itcJPEG ); /* Load image and assign image index */
		PB = PDFPageCreatePaintBox(doc, Page, 72);            /* Create paintbox */
		PBXShowImage ( PB, I, 100.0, 100.0, 200, 200, 30);     /* Insert image into document on the current page slopping 30grad*/
		PBXClose( PB, true );                                 /* Close paintbox */
		PDFDocSaveToFile( doc, "../Data/out/PngTest.pdf" );  /* Saving the document */ 
	} PDFFINALLY( PDFLibrary ){                               /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}