/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TLinkAnnotDict LinkAnnotation;  /* Link annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			LinkAnnotation.Contents = "Link annotation";     /* Annotation content filling */
			LinkAnnotation.ContLength = 15;
			LinkAnnotation.Open = true;                      /* Set open property to true */
			LinkAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
			LinkAnnotation.DateTime = NULL;
			LinkAnnotation.Action = CosNewNull ( doc );      
			LinkAnnotation.AdditAction = CosNewNull ( doc );
			LinkAnnotation.Popup = CosNewNull ( doc );
            LinkAnnotation.AnFlags = 0;
            LinkAnnotation.Transparency = 1;
			LinkAnnotation.Rectangle.pt1.X = 100;              /* Setting annotation sizes */
			LinkAnnotation.Rectangle.pt1.Y = 400;
			LinkAnnotation.Rectangle.pt2.X = 500;
			LinkAnnotation.Rectangle.pt2.Y = 800;
			LinkAnnotation.Color.blue = 0.0;                   /* Setting annotation color to yellow */ 
			LinkAnnotation.Color.red = 1.0;
			LinkAnnotation.Color.green = 1.0;
			LinkAnnotation.TitleText = "Link title";   /* Setting annotation title */
			LinkAnnotation.TTLength = 10;
			PDFPageAddLinkAnnotation( doc, 0, LinkAnnotation ); /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/LinkAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}