/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>

#include "VSLibA.h"         /* Use Versy PDF Library */
#include "VSExcept.h"       /* Use Exceptions API */
#include "VSError.h"        /* Use Errors API */
#include "VSTypes.h"        /* Use Versy Type Definitions */
#include "VSDocA.h"         /* Use PDF Document API */
#include "VSFontA.h"        /* Use Common Versy PDF Routines */
#include "VSPageA.h"        /* Use PDF Page Document API */

#include "VSCanvasA.h"  /* Use Acro Objects API */
#include "VSGStateA.h"  /* Use Acro Objects API */

#define PageWidth   595    /* Page width definition */
#define PageHeight  842    /* Page height definition */
/* Determination of graphics objects coordinates, normalized to 100 */
#define cx(x) (PageWidth*(x)/100)
#define cy(y) (PageHeight*(y)/100)

#define rnd ((ppReal)rand()/(ppReal)RAND_MAX) /* Random number from 0 to 1 */
#define FiguresCount 200   /* Count of figures per one example */

char *LineDashTypes[ 9 ] = { "[2 2] 0", "[4 4] 0", "[8 8] 0", "[8 8] 4", "[8 8] 8", "[12 4] 0",
                             "[16 3 4 3] 0", "[13 3 2 3 2 3] 0", "[ ] 0" };

int main()
{
    PDFLibHandle	PDFLibrary;     /* PDF Library Handle */
	PDFDocHandle	Doc = NULL;     /* PDF Document Handle */
    PBXHandle       PaintBox;       /* Handle of Paint Box for Content Drawing */

    char            TextString[255];

    ppInt32         ErrorCode;      /* Check Error Code */
    ppInt32         PageIndex;      /* Index of Page in Document */
    ppInt32         i;              /* Variable counter */
    ppReal          a, b, c, d;     /* Parameters variables */

    PDFLibrary = InitPDFLibrary( NULL, NULL ); /* Initialize PDF Library */
    PDFTRY( PDFLibrary )/* On error keep exception */

        Doc = PDFDocCreate( PDFLibrary ); /* Create new destination PDF file */
        PDFDocSetAutoLaunch( Doc, true );/* Launch destination PDF file after work */

        /************************************************************************/
        /* Text Fonts Example                                                   */
        /************************************************************************/
        /* Create new page in PDF document */
        PageIndex = PDFDocAppendPage( Doc, PageWidth, PageHeight );
        /* Create Page Content PaintBox with default resolution ( 72 dpi )*/
        PaintBox = PDFPageCreatePaintBox( Doc, PageIndex, 72 );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set active font as Helvetica, size is 4% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(4), false, false );
        /* Font color is black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title of current page */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Lines" )/2, cy(4), 0, "Lines" );
        /* Set active font as Helvetica, size is 1.2% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelveticaBold, etStandardEncoding ),
            cy(1.2), false, false );
        /* Draw title of current example near right border of page */
        PBXTextOut( PaintBox, cx(80), cy(9), 0, "Dash Types" );

        /* Set stroke color as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw 9 types of dashed lines from dash type array - LineDashTypes */
        for ( i = 0; i < 9; i++ ) {
            /* Set dash type from string's array */
            PBXSetDash( PaintBox, LineDashTypes[ i ] );
            /* Move current position on PaintBox in start of line */
            PBXMoveTo( PaintBox, cx( 10 ), cy( 10 + 3 * i ) );
            /* Draw line from left side to right */
            PBXLineTo( PaintBox, cx( 60 ), cy( 10 + 3 * i ) );
            /* ... and colorize it */
            PBXStroke( PaintBox );
            /* Draw dash type as text near example line */
            PBXTextOut( PaintBox, cx(62), cy( 9.5 + 3 * i ), 0, LineDashTypes[ i ] );
        }

        /* Draw title of current example near right border of page,
        and in 39% of page height from top */
        PBXTextOut( PaintBox, cx(80), cy(39), 0, "Width Values" );
        for ( i = 0; i < 19; i++ ) {
            /* Increase line width from 0 to 4.5 by 0.25 points */
            PBXSetLineWidth( PaintBox, 0.25 * i );
            /* Set line color as dark blue */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.5 ) );
            /* Move current position on PaintBox in start of line */
            PBXMoveTo( PaintBox, cx( 10 ), cy( 40 + 3 * i ) );
            /* Draw line from left side to right */
            PBXLineTo( PaintBox, cx( 60 ), cy( 40 + 3 * i ) );
            /* ... and colorize it */
            PBXStroke( PaintBox );
            /* Create line width value as text ... */
            sprintf( TextString, "Line width = %4.2f", 0.25 * i );
            /* ... and draw text label near example line */
            PBXTextOut( PaintBox, cx( 62 ), cy( 39.5 + 3 * i ), 0, TextString );
        }
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );
        /* Save non-packed Page Content and Free PaintBox */
        PBXClose( PaintBox, false );

        /********************************************************************************/
        /* Draw graphic primitives as rectangles, rotated rectangles, ellipses, circles */
        /********************************************************************************/
        /* Create new page in PDF document */
        PageIndex = PDFDocAppendPage( Doc, PageWidth, PageHeight );
        /* Create Page Content PaintBox with default resolution ( 72 dpi )*/
        PaintBox = PDFPageCreatePaintBox( Doc, PageIndex, 72 );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set active font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(3), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Rectangles' */
        PBXTextOut( PaintBox, cx(28) - PBXGetTextWidth( PaintBox, "Rectangles" )/2, cy(4), 0, "Rectangles" );
        /* End the path object without filling or stroking it. */
        PBXNewPath( PaintBox );
        /* Set big rectangle for inserting other rectangles */
        PBXRectangle( PaintBox, cx(10), cy(10), cx(45), cy(45) );
        /* Check path for clipping */
        PBXClip( PaintBox );
        /* Start new path for drawing */
        PBXNewPath( PaintBox );
        /* Set line width as 0.5 points */
        PBXSetLineWidth( PaintBox, 0.5 );
        /* Initialize number generation : rnd is number from 0 to 1 */
        srand( 0 );
        /* Draw rectangles in clipping path area */
        for ( i = 0; i < FiguresCount; i++ ) {
            /* Set randomize stroke color */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( rnd, rnd, rnd ) );
            /* Set randomize fill color */
            PBXSetFillColor( PaintBox, ULRGBToColor( rnd, rnd, rnd ) );
            /* Random X-coordinate of left border */
            a = cx( 5 ) + cx( 35 * rnd );
            /* Random Y-coordinate of top border */
            b = cy( 5 ) + cy( 35 * rnd );
            /* Random width of rectangle */
            c = cx( 10 * rnd );
            /* Random height of rectangle */
            d = cy( 10 * rnd );
            /* Draw this rectangle */
            PBXRectangle( PaintBox, a, b, a + c, b + d );
            /* ... and colorize it */
            PBXFillAndStroke( PaintBox );
        }
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );
        /* Start new path for drawing without old clipping path */
        PBXNewPath( PaintBox );
        /* Set line width as 3 points */
        PBXSetLineWidth( PaintBox, 3 );
        /* Set line color of rectangle as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw dribble rectangle */
        PBXRectangle( PaintBox, cx(10), cy(10), cx(45), cy(45) );
        /* ... and colorize it */
        PBXStroke( PaintBox );
        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the text font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(3), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Rotated rectangles' */
        PBXTextOut( PaintBox, cx(74) - PBXGetTextWidth( PaintBox, "Rotated rectangles" )/2, cy(4), 0, "Rotated rectangles" );
        /* End the path object without filling or stroking it. */
        PBXNewPath( PaintBox );
        /* Set big rectangle for inserting other rectangles */
        PBXRectangle( PaintBox, cx(55), cy(10), cx(90), cy(45) );
        /* Check path for clipping */
        PBXClip( PaintBox );
        /* Start new path for drawing */
        PBXNewPath( PaintBox );
        /* Set line width as 0.5 points */
        PBXSetLineWidth( PaintBox, 0.5 );
        /* Initialize number generation : rnd is number from 0 to 1 */
        srand( 0 );
        /* Draw rotated rectangles in clipping path area */
        for ( i = 0; i < FiguresCount; i++ ) {
            /* Set randomize stroke color */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( rnd, rnd, rnd ) );
            /* Set randomize fill color */
            PBXSetFillColor( PaintBox, ULRGBToColor( rnd, rnd, rnd ) );
            /* Random X-coordinate of left border */
            a = cx( 50 ) + cx( 35 * rnd );
            /* Random Y-coordinate of top border */
            b = cy( 90 ) - cy( 35 * rnd );
            /* Random width of rectangle */
            c = cx( 10 * rnd );
            /* Random height of rectangle */
            d = cy( 10 * rnd );
            /* Draw this rectangle which rotated on randomize angle form -45 to 45 degrees */
            PBXRectRotated( PaintBox, a, b, c, d, 90 * rnd - 45 );
            /* ... and colorize it */
            PBXFillAndStroke( PaintBox );
        }
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );
        /* Start new path for drawing without old clipping path */
        PBXNewPath( PaintBox );
        /* Set line width as 3 points */
        PBXSetLineWidth( PaintBox, 3 );
        /* Set line color of rectangle as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw dribble rectangle */
        PBXRectangle( PaintBox, cx(55), cy(10), cx(90), cy(45) );
        /* ... and colorize it */
        PBXStroke( PaintBox );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the text font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(3), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Ellipses' */
        PBXTextOut( PaintBox, cx(28) - PBXGetTextWidth( PaintBox, "Ellipses" )/2, cy(49), 0, "Ellipses" );
        /* End the path object without filling or stroking it. */
        PBXNewPath( PaintBox );
        /* Draw big ellipse for inserting other ellipses */
        PBXEllipse( PaintBox, cx(10), cy(55), cx(45), cy(90) );
        /* Check path for clipping */
        PBXClip( PaintBox );
        /* Start new path for drawing */
        PBXNewPath( PaintBox );
        /* Set line width as 0.5 points */
        PBXSetLineWidth( PaintBox, 0.5 );
        /* Draw ellipses in clipping path area */
        for ( i = 0; i < FiguresCount; i++ ) {
            /* Set randomize stroke color */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( rnd, rnd, rnd ) );
            /* Set randomize fill color */
            PBXSetFillColor( PaintBox, ULRGBToColor( rnd, rnd, rnd ) );
            /* Random X-coordinate of left border */
            a = cx( 5 ) + cx( 35 * rnd );
            /* Random Y-coordinate of top border */
            b = cy( 50 ) + cy( 35 * rnd );
            /* Random width of ellipse */
            c = cx( 10 * rnd );
            /* Random height of ellipse */
            d = cy( 10 * rnd );
            /* Draw this ellipse */
            PBXEllipse( PaintBox, a, b, a + c, b + d );
            /* ... and colorize it */
            PBXFillAndStroke( PaintBox );
        }
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );
        /* Start new path for drawing without old slipping path */
        PBXNewPath( PaintBox );
        /* Set line width as 3 points */
        PBXSetLineWidth( PaintBox, 3 );
        /* Set line color of rectangle as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw dribble ellipse */
        PBXEllipse( PaintBox, cx(10), cy(55), cx(45), cy(90) );
        /* ... and colorize it */
        PBXStroke( PaintBox );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the text font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(3), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Circles' */
        PBXTextOut( PaintBox, cx(74) - PBXGetTextWidth( PaintBox, "Circles" )/2, cy(49), 0, "Circles" );
        /* End the path object without filling or stroking it. */
        PBXNewPath( PaintBox );
        /* Draw big circle for inserting other circles */
        PBXCircle( PaintBox, cx(73), cy(73), cx(18) );
        /* Check path for clipping */
        PBXClip( PaintBox );
        /* Start new path for drawing */
        PBXNewPath( PaintBox );
        /* Set line width as 0.5 points */
        PBXSetLineWidth( PaintBox, 0.5 );
        /* Draw circles in clipping path area */
        for ( i = 0; i < FiguresCount; i++ ) {
            /* Set randomize stroke color */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( rnd, rnd, rnd ) );
            /* Set randomize fill color */
            PBXSetFillColor( PaintBox, ULRGBToColor( rnd, rnd, rnd ) );
            /* Random X-coordinate of circle center */
            a = cx( 55 ) + cx( 35 * rnd );
            /* Random Y-coordinate of circle center */
            b = cy( 55 ) + cy( 35 * rnd );
            /* Random radius of circle */
            c = cx( 5 * rnd );
            /* Draw this circle */
            PBXCircle( PaintBox, a, b, c );
            /* ... and colorize it */
            PBXFillAndStroke( PaintBox );
        }
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );
        /* Start new path for drawing without old slipping path */
        PBXNewPath( PaintBox );
        /* Set line width as 3 points */
        PBXSetLineWidth( PaintBox, 3 );
        /* Set line color of rectangle as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw dribble circle */
        PBXCircle( PaintBox, cx(73), cy(73), cx(18) );
        /* ... and colorize it */
        PBXStroke( PaintBox );

        /* Save non-packed Page Content and Free PaintBox */
        PBXClose( PaintBox, false );

        /************************************************************************/
        /* Draw round rectangles, pies and Bezier curves. Example.              */
        /************************************************************************/
        /* Create new page in PDF document */
        PageIndex = PDFDocAppendPage( Doc, PageWidth, PageHeight );
        /* Create Page Content PaintBox with default resolution ( 72 dpi )*/
        PaintBox = PDFPageCreatePaintBox( Doc, PageIndex, 72 );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set active font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(3), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Round rectangles' */
        PBXTextOut( PaintBox, cx(28) - PBXGetTextWidth( PaintBox, "Round rectangles" )/2, cy(4), 0, "Round rectangles" );

        /* Stroke color set a maroon */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.6, 0.0, 0.0 ) );
        /* Fill color set a white */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 1.0, 1.0 ) );
        /* Draw 8 round rectangles with variable parameters */
        for ( i = 0; i < 8; i++ ) {
            /* Change line width from 0 to 5 points */
            PBXSetLineWidth( PaintBox, 2*i/3 );
            /* Draw round rectangle */
            PBXRoundRect( PaintBox, cx( 10 + i), cy(10 + i), cx(45 - i), cy(45 - i), cx(3 * i), cy(3 * i) );
            /* ... and colorize it */
            PBXFillAndStroke( PaintBox );
        }
        /* Stroke color set a white */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 1.0, 1.0, 1.0 ) );
        /* Fill color set a maroon */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.6, 0.0, 0.0 ) );
        /* Draw 8 round rectangles with variable parameters */
        for ( i = 8; i < 16; i++ ) {
            /* Change line width from 5 to 0 points */
            PBXSetLineWidth( PaintBox, 10 - 2*i/3 );
            /* Draw round rectangle */
            PBXRoundRect( PaintBox, cx( 10 + i), cy(10 + i), cx(45 - i), cy(45 - i), cx( 45 - 3 * i ), cy( 45 - 3 * i ) );
            /* ... and colorize it */
            PBXFillAndStroke( PaintBox );
        }
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the text font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(3), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Pies' */
        PBXTextOut( PaintBox, cx(74) - PBXGetTextWidth( PaintBox, "Pies" )/2, cy(4), 0, "Pies" );
        /* Stroke color set a maroon */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.6, 0.0, 0.0 ) );
        /* Fill color set a red */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 0.0, 0.0 ) );
        /* Set line width as 1 point */
        PBXSetLineWidth( PaintBox, 1 );
        /* Set join style as Mode 0 */
        PBXSetLineJoin( PaintBox, 1 );
        /* Draw big pie */
        PBXPie( PaintBox, cx(50), cy(15), cx(85), cy(40), cx(90), cy(15), cx(90), cy(40) );
        /* ... and colorize it */
        PBXFillAndStroke( PaintBox );
        /* Stroke color set a dark green */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.6, 0.0 ) );
        /* Fill color set a green */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 1.0, 0.0 ) );
        /* Draw small pie */
        PBXPie( PaintBox, cx(60), cy(15), cx(95), cy(40), cx(100), cy(40), cx(100), cy(15) );
        /* ... and colorize it */
        PBXFillAndStroke( PaintBox );
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the text font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(3), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Cubic Bezier curves' */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Cubic Bezier curves" )/2, cy(49),
            0, "Cubic Bezier curves" );

        /* Set line color as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Set line width as 1 point */
        PBXSetLineWidth( PaintBox, 1 );
        /* Set dash line style as Solid ( default )*/
        PBXNoDash( PaintBox );
        /* Move current position on PaintBox in start of Bezier Curve */
        PBXMoveTo( PaintBox, cx(65), cy(90) );
        /* Draw Bezier Curve with cubic interpolation by 2 points and 1 destination point */
        PBXCurveTo( PaintBox, cx(50), cy(70), cx(90), cy(70), cx(75), cy(85) );
        /* ... and colorize it */
        PBXStroke( PaintBox );

        /* Set line color as gray */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.5, 0.5, 0.5 ) );
        /* Set line width as 0.25 points */
        PBXSetLineWidth( PaintBox, 0.25 );
        /* Set dash line style as dash-dotted mode */        
        PBXSetDash( PaintBox, "[3 3] 0" );
        /* Move current position on PaintBox in start of Bezier Curve */
        PBXMoveTo( PaintBox, cx(65), cy(90) );
        /* Draw interpolation vector from start to first interpolation point */
        PBXLineTo( PaintBox, cx(50), cy(70) );
        /* ... and colorize it */
        PBXStroke( PaintBox );
        /* Move current position on PaintBox in finish of Bezier Curve */
        PBXMoveTo( PaintBox, cx(75), cy(85) );
        /* Draw interpolation vector from finish to second interpolation point */
        PBXLineTo( PaintBox, cx(90), cy(70) );
        /* ... and colorize it */
        PBXStroke( PaintBox );

        /* Draw bold maroon point as circle in start of Bezier Curve */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.6, 0.0, 0.0 ) );
        PBXCircle( PaintBox, cx(65), cy(90), 3 );
        PBXFill( PaintBox );

        /* Draw bold dark blue point as circle in first interpolation point */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.3 ) );
        PBXCircle( PaintBox, cx(50), cy(70), 2 );
        PBXFill( PaintBox );

        /* Draw bold dark blue point as circle in second interpolation point */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.3 ) );
        PBXCircle( PaintBox, cx(90), cy(70), 2 );
        PBXFill( PaintBox );

        /* Draw bold dark green point as circle in finish of Bezier Curve */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.6, 0.0 ) );
        PBXCircle( PaintBox, cx(75), cy(85), 2.5 );
        PBXFill( PaintBox );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the text font as Helvetica, size is 1% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(1), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw caption of point in start of Bezier Curve as 'x0, y0 - current point' */
        PBXTextOut( PaintBox, cx(67) - PBXGetTextWidth( PaintBox, "x0, y0 - current point" )/2, cy(91),
            0, "x0, y0 - current point" );
        /* Draw caption of first interpolation point as 'x1, y1 - interpolation point' */
        PBXTextOut( PaintBox, cx(52) - PBXGetTextWidth( PaintBox, "x1, y1 - interpolation point" )/2, cy(71),
            0, "x1, y1 - interpolation point" );
        /* Draw caption of second interpolation point as 'x2, y2 - interpolation point' */
        PBXTextOut( PaintBox, cx(92) - PBXGetTextWidth( PaintBox, "x2, y2 - interpolation point" )/2, cy(71),
            0, "x2, y2 - interpolation point" );
        /* Draw caption of point in finish of Bezier Curve as 'x3, y3 - destination point' */
        PBXTextOut( PaintBox, cx(77) - PBXGetTextWidth( PaintBox, "x3, y3 - destination point" )/2, cy(86),
            0, "x3, y3 - destination point" );
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );


        /* One more example of Cubic Bezier curves */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        PBXSetLineWidth( PaintBox, 1 );
        PBXNoDash( PaintBox );
        PBXMoveTo( PaintBox, cx(10), cy(60) );
        PBXCurveTo( PaintBox, cx(20), cy(50), cx(40), cy(75), cx(45), cy(60) );
        PBXStroke( PaintBox );

        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.5, 0.5, 0.5 ) );
        PBXSetLineWidth( PaintBox, 0.25 );
        PBXSetDash( PaintBox, "[3 3] 0" );
        PBXMoveTo( PaintBox, cx(10), cy(60) );
        PBXLineTo( PaintBox, cx(20), cy(50) );
        PBXStroke( PaintBox );
        PBXMoveTo( PaintBox, cx(45), cy(60) );
        PBXLineTo( PaintBox, cx(40), cy(75) );
        PBXStroke( PaintBox );


        /* One more example of Cubic Bezier curves */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        PBXSetLineWidth( PaintBox, 1 );
        PBXNoDash( PaintBox );
        PBXMoveTo( PaintBox, cx(10), cy(90) );
        PBXCurveTo( PaintBox, cx(35), cy(88), cx(30), cy(75), cx(45), cy(90) );
        PBXStroke( PaintBox );

        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.5, 0.5, 0.5 ) );
        PBXSetLineWidth( PaintBox, 0.25 );
        PBXSetDash( PaintBox, "[3 3] 0" );
        PBXMoveTo( PaintBox, cx(10), cy(90) );
        PBXLineTo( PaintBox, cx(35), cy(88) );
        PBXStroke( PaintBox );
        PBXMoveTo( PaintBox, cx(45), cy(90) );
        PBXLineTo( PaintBox, cx(30), cy(75) );
        PBXStroke( PaintBox );

        PBXClose( PaintBox, false ); /* Free PaintBox of Page Content */

        /************************************************************************/
        /* Alpha blending example.                                              */
        /************************************************************************/
        /* Create new page in PDF document */
        PageIndex = PDFDocAppendPage( Doc, PageWidth, PageHeight );
        /* Create Page Content PaintBox with default resolution ( 72 dpi )*/
        PaintBox = PDFPageCreatePaintBox( Doc, PageIndex, 72 );

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the text font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(3), false, false );
        /* Text Color set a black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title of current page */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Alpha blending" )/2, cy(4),
            0, "Alpha blending" );

        i = PDFExtGraphicStateCreate( Doc );                        /* Create Graphic state */
        PDFExtGraphicStateSetAlphaFill( Doc, i, 0.5 );              /* Set fill alpha blending to 50 % */
        PDFExtGraphicStateSetAlphaStroke( Doc, i, 0.5 );            /* Set lines alpha blending to 50 % */
        PDFExtGraphicStateSetAlphaIsShape( Doc, i, true );          /* Set alpha blending to shapes */
        PBXSetGState ( PaintBox, i );                               /* Set graphic state as current */
        PBXSetColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );     /* Set line color as black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 1.0, 0.0 ) ); /* Set fill color as yellow  */
        PBXRectangle( PaintBox, cx(10), cy(10), cx(60), cy(60) );   /* Draw rectangle */
        PBXFillAndStroke( PaintBox );                               /* Close and fill rectangle */
        PBXSetColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );     /* Set line color as black  */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 0.0, 0.0 ) ); /* Set fill color as red */
        PBXRectangle( PaintBox, cx(20), cy(20), cx(70), cy(70) );   /* Draw rectangle */
        PBXFillAndStroke( PaintBox );                               /* Close and fill rectangle */
        PBXSetColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );     /* Set line color as black  */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 1.0 ) ); /* Set fill color as blue  */
        PBXRectangle( PaintBox, cx(30), cy(30), cx(80), cy(80) );   /* Draw rectangle */
        PBXFillAndStroke( PaintBox );                               /* Close and fill rectangle */
        PBXSetColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );     /* Set line color as black  */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 1.0, 0.0 ) ); /* Set fill color as green  */
        PBXRectangle( PaintBox, cx(40), cy(40), cx(90), cy(90) );   /* Draw rectangle */
        PBXFillAndStroke( PaintBox );                               /* Close and fill rectangle */
        PBXClose( PaintBox, false );                                /* Close paintbox */


        /* Save destination PDF file as "graphics.pdf" in current path */
        PDFDocSaveToFile( Doc, "../Data/out/Graphics.pdf" );
    PDFFINALLY( PDFLibrary ) /* Do further if haven't PDF Library Exceptions */
		if ( Doc ) PDFDocClose ( Doc ); /* Close PDF Document and free memory */
		ErrorCode = PDFLASTERROR( PDFLibrary ); /* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary );/* Free PDF Library */
    PDFTRYEND( PDFLibrary ); /* End of try...end block */
    return ErrorCode; /* Return Error Code as program result */
}

