#region (C) Wout Ware 2005
//
// File: DxfViewExample.cs
// Author: Wout de Zeeuw
// Creation: 4/17/2005
//
// (c) 2005 Wout Ware All Rights Reserved.
//
#endregion
using System;
using System.Drawing;
using System.Windows.Forms;

using CadLib.Base;
using CadLib.Drawing;
using CadLib.Drawing.GDI;
using CadLib.IO;
using CadLib.Model;

using Sharp3D.Math.Core;
using Sharp3D.Math.Geometry3D;

namespace DxfViewExample
{
	/// <summary>
	/// A simple dxf viewer example.
	/// </summary>
	public class DxfViewExample : System.Windows.Forms.Form
	{
		private CadData data;
		private GDIGraphics3D gdiGraphics3D;
		private Bounds3D bounds;
		private Matrix4D modelTransform = Matrix4D.Identity;
		
		public DxfViewExample(string filename)
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			// To prevent flicker.
			SetStyle(ControlStyles.AllPaintingInWmPaint, true);
			SetStyle(ControlStyles.DoubleBuffer, true);
			SetStyle(ControlStyles.UserPaint, true);
			
			BackColor = Color.Black;

			try {
				data = DxfReader.ReadDxf(filename);
			} catch (Exception e) {
				MessageBox.Show("Error occurred: " + e.Message);
				Environment.Exit(1);
			}
			
			gdiGraphics3D = new GDIGraphics3D(CadGraphicsConfig.Default, BackColor);
			gdiGraphics3D.CreateDrawables(data);

			// Uncomment for rotation example.
//			modelTransform = TransformationD.RotateX(-30d * Math.PI / 180d) *
//				TransformationD.RotateZ(150d * Math.PI / 180d);
			bounds = new Bounds3D();
			gdiGraphics3D.BoundingBox(bounds, modelTransform);
			CalculateTo2DTransform();
		}
		
		private void CalculateTo2DTransform() {
			if (bounds != null) {
				Matrix4D to2DTransform = CadUtil.GetScaleTransform(
					bounds.Corner1,
					bounds.Corner2,
					bounds.Center,
					new Vector3D(0d, ClientSize.Height, 0d),
					new Vector3D(ClientSize.Width, 0d, 0d),
					new Vector3D(ClientSize.Width / 2, ClientSize.Height / 2, 0d)
				);
				gdiGraphics3D.To2DTransform = to2DTransform * modelTransform;
			}
		}
		
		protected override void OnResize(EventArgs e) {
			base.OnResize(e);
			CalculateTo2DTransform();
			Invalidate();
		}
		
		protected override void OnPaint(PaintEventArgs e) {
			gdiGraphics3D.Draw(e.Graphics, ClientRectangle);
		}
		
		[STAThread]
		public static void Main(string[] args)
		{
			if (args.Length != 1) {
				MessageBox.Show("Usage: DxfViewExample <dxf file>");
				return;
			}
			Application.Run(new DxfViewExample(args[0]));
		}
		
		#region Windows Forms Designer generated code
		/// <summary>
		/// This method is required for Windows Forms designer support.
		/// Do not change the method contents inside the source code editor. The Forms designer might
		/// not be able to load this method if it was changed manually.
		/// </summary>
		private void InitializeComponent() {
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DxfViewExample));
			// 
			// DxfViewExample
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "DxfViewExample";
			this.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.Text = "CadLib Demo";
		}
		#endregion
	}
}
