/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import XMLConsumer.ITocEntryContainer;
import XMLConsumer.TocEntry;
import hhapplet.IActionSink;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class TocBlock
implements ITocEntryContainer {
    private Vector m_vEntries;
    private int m_nTop;
    private int m_nHeight;
    private int m_nWidth;
    private boolean m_bNeedCalWidth;
    private boolean m_bVisible;
    private Hashtable m_hashSubBlock;
    private TocEntry m_teParent;
    private IActionSink m_accepter;

    public void insertTocBlock(TocEntry tocEntry, TocBlock tocBlock) {
        if (tocEntry != null) {
            int n = tocEntry.getIndex();
            tocBlock.setParentEntry(tocEntry);
            if (this.m_hashSubBlock == null) {
                this.m_hashSubBlock = new Hashtable();
            }
            this.m_hashSubBlock.put(new Integer(n), tocBlock);
            boolean bl = tocEntry.isOpen() && this.isEntryVisible(tocEntry);
            tocBlock.setVisible(bl);
            tocBlock.setTop(this.getPosition(n) + 1);
            if (bl) {
                this.propagateHeightChange(tocBlock, tocBlock.getHeight());
            }
        }
    }

    public TocBlock(IActionSink iActionSink, Vector vector) {
        this.m_vEntries = vector;
        this.m_nWidth = 0;
        this.m_nTop = 0;
        this.m_bVisible = true;
        this.m_accepter = iActionSink;
        this.m_bNeedCalWidth = true;
        Enumeration enumeration = this.m_vEntries.elements();
        while (enumeration.hasMoreElements()) {
            TocEntry tocEntry = (TocEntry)enumeration.nextElement();
            tocEntry.setContainer(this);
        }
        this.calPosOffset();
    }

    public TocEntry getEntry(int n) {
        int n2;
        int n3 = n - this.m_nTop;
        if (n3 >= 0 && n3 < this.m_nHeight && (n2 = this.getFirstIndex(n3, 1)) != -1) {
            TocEntry tocEntry = (TocEntry)this.m_vEntries.elementAt(n2);
            return tocEntry;
        }
        return null;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = false;
        if (this.m_bVisible != bl) {
            bl2 = true;
        }
        this.m_bVisible = bl;
        if (bl2) {
            this.propagateVisibility();
        }
    }

    public TocEntry getEntryByIdx(int n) {
        if (n >= 0 && n < this.m_vEntries.size()) {
            return (TocEntry)this.m_vEntries.elementAt(n);
        }
        return null;
    }

    public int getTop() {
        return this.m_nTop;
    }

    public void setTop(int n) {
        int n2 = n - this.m_nTop;
        this.m_nTop = n;
        if (this.m_hashSubBlock != null) {
            Enumeration enumeration = this.m_hashSubBlock.keys();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                TocBlock tocBlock = (TocBlock)this.m_hashSubBlock.get(n3);
                int n4 = tocBlock.getTop();
                tocBlock.setTop(n4 + n2);
            }
        }
    }

    protected void updateHeightChange(int n, int n2) {
        int n3 = n;
        while (n3 < this.m_vEntries.size()) {
            TocBlock tocBlock;
            TocEntry tocEntry = (TocEntry)this.m_vEntries.elementAt(n3);
            tocEntry.updatePosOffset(n2);
            if (tocEntry.isStubEntry() && (tocBlock = this.getSubBlock(n3)) != null) {
                int n4 = tocBlock.getTop();
                tocBlock.setTop(n4 + n2);
            }
            ++n3;
        }
    }

    public TocBlock getParentBlock() {
        TocEntry tocEntry = this.getParentEntry();
        if (tocEntry != null) {
            return (TocBlock)tocEntry.getContainer();
        }
        return null;
    }

    public TocBlock getSubBlock(int n) {
        Object v;
        if (this.m_hashSubBlock != null && (v = this.m_hashSubBlock.get(new Integer(n))) != null && v instanceof TocBlock) {
            return (TocBlock)v;
        }
        return null;
    }

    public void calPosOffset() {
        this.m_nHeight = 0;
        TocEntry tocEntry = (TocEntry)this.m_vEntries.elementAt(0);
        this.m_nHeight = this.calPosOffsetWithEntry(tocEntry, -1, this.m_bVisible) + 1;
    }

    public void setNeedCalWidth() {
        this.m_bNeedCalWidth = true;
    }

    protected int calPosOffsetWithEntry(TocEntry tocEntry, int n, boolean bl) {
        while (tocEntry != null) {
            n = this.calOffSpringPosOff(tocEntry, n, bl);
            tocEntry = tocEntry.getNextSibling();
        }
        return n;
    }

    public TocEntry getParentEntry() {
        return this.m_teParent;
    }

    public void setParentEntry(TocEntry tocEntry) {
        this.m_teParent = tocEntry;
    }

    protected int calWidth(Graphics graphics) {
        TocEntry tocEntry = (TocEntry)this.m_vEntries.elementAt(0);
        return this.getOffSpringMaxWidth(graphics, tocEntry);
    }

    protected int getOffSpringMaxWidth(Graphics graphics, TocEntry tocEntry) {
        int n = 0;
        int n2 = 0;
        while (tocEntry != null) {
            n2 = tocEntry.getWidth(graphics);
            if (n2 > n) {
                n = n2;
            }
            if (tocEntry.isOpen()) {
                TocEntry tocEntry2 = tocEntry.getFirstChild();
                n2 = this.getOffSpringMaxWidth(graphics, tocEntry2);
            }
            if (n2 > n) {
                n = n2;
            }
            tocEntry = tocEntry.getNextSibling();
        }
        return n;
    }

    public boolean isVisible() {
        return this.m_bVisible;
    }

    public int getFirstIndex(int n, int n2) {
        TocEntry tocEntry;
        int n3 = -1;
        if (this.m_vEntries.size() > 0 && this.isEntryVisible(tocEntry = (TocEntry)this.m_vEntries.elementAt(0))) {
            return this.getFirstVisibleEntryIndex(tocEntry, n, n2);
        }
        return n3;
    }

    protected int calOffSpringPosOff(TocEntry tocEntry, int n, boolean bl) {
        if (bl && !tocEntry.isStubEntry()) {
            tocEntry.setPosOffset(++n);
        } else {
            tocEntry.setPosOffset(n);
            if (tocEntry.isStubEntry()) {
                if (!tocEntry.isStubFilled()) {
                    if (bl && this.m_accepter != null) {
                        tocEntry.action(this.m_accepter);
                    }
                } else {
                    TocBlock tocBlock = this.getSubBlock(tocEntry.getIndex());
                    if (tocBlock != null) {
                        tocBlock.setTop(this.m_nTop + n + 1);
                        tocBlock.setVisible(bl);
                        tocBlock.calPosOffset();
                        n += tocBlock.getHeight();
                    }
                }
            }
        }
        if (tocEntry.getFirstChild() != null) {
            n = tocEntry.isOpen() ? this.calPosOffsetWithEntry(tocEntry.getFirstChild(), n, bl) : this.calPosOffsetWithEntry(tocEntry.getFirstChild(), n, false);
        }
        return n;
    }

    public int getPosition(int n) {
        TocEntry tocEntry = (TocEntry)this.m_vEntries.elementAt(n);
        return this.m_nTop + tocEntry.getPosOffset();
    }

    protected void propagateHeightChange(TocBlock tocBlock, int n) {
        if (this.m_hashSubBlock != null && this.m_hashSubBlock.contains(tocBlock)) {
            Enumeration enumeration = this.m_hashSubBlock.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                if (this.m_hashSubBlock.get(n2) != tocBlock) continue;
                int n3 = n2;
                this.updateHeightChange(n3 + 1, n);
                break;
            }
        }
        this.m_nHeight += n;
        if (this.getParentBlock() != null) {
            this.getParentBlock().propagateHeightChange(this, n);
        }
    }

    protected void propagateVisibility() {
        if (this.m_hashSubBlock != null) {
            Enumeration enumeration = this.m_hashSubBlock.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                TocBlock tocBlock = (TocBlock)this.m_hashSubBlock.get(n);
                TocEntry tocEntry = (TocEntry)this.m_vEntries.elementAt(n);
                if (!tocEntry.isOpen()) continue;
                tocBlock.setVisible(this.m_bVisible);
            }
        }
    }

    public int getHeight() {
        return this.m_nHeight;
    }

    public int getCount() {
        return this.m_vEntries.size();
    }

    public void callPosOffsetByEntry(TocEntry tocEntry) {
        TocEntry tocEntry2 = tocEntry.getNextOut();
        int n = this.m_vEntries.size() - 1;
        if (tocEntry2 != null) {
            n = tocEntry2.getIndex() - 1;
        }
        if (n >= 0 && n != tocEntry.getIndex()) {
            TocBlock tocBlock;
            TocEntry tocEntry3 = (TocEntry)this.m_vEntries.elementAt(n);
            int n2 = tocEntry3.getPosOffset();
            if (tocEntry3.isStubEntry() && tocEntry3.isStubFilled() && (tocBlock = this.getSubBlock(tocEntry3.getIndex())) != null) {
                n2 += tocBlock.getHeight();
            }
            int n3 = this.calOffSpringPosOff(tocEntry, tocEntry.getPosOffset() - 1, true);
            int n4 = n3 - n2;
            if (tocEntry2 != null) {
                int n5 = tocEntry2.getIndex();
                this.updateHeightChange(n5, n4);
            }
            this.m_nHeight += n4;
        }
    }

    public void display(Graphics graphics, int n, int n2, int n3, Color color, Image image) {
        int n4 = n - this.m_nTop;
        int n5 = n4 > 0 ? n4 : 0;
        int n6 = this.getFirstIndex(n5, n2);
        if (n6 != -1) {
            int n7 = n6;
            while (n7 < this.m_vEntries.size()) {
                TocEntry tocEntry;
                TocEntry tocEntry2 = (TocEntry)this.m_vEntries.elementAt(n7);
                if (tocEntry2.getPosOffset() >= n2 + n4) break;
                if (this.isEntryVisible(tocEntry2)) {
                    if (!tocEntry2.isStubEntry()) {
                        tocEntry2.display(graphics, tocEntry2.getPosOffset() - n4, n3, color, image);
                    }
                    ++n7;
                    continue;
                }
                TocEntry tocEntry3 = tocEntry2.getDirectParent();
                if (tocEntry3 == null || (tocEntry = tocEntry3.getNextOut()) == null) break;
                n7 = tocEntry.getIndex();
            }
        }
    }

    public int getWidth(Graphics graphics) {
        if (this.isVisible()) {
            if (this.m_bNeedCalWidth) {
                this.m_bNeedCalWidth = false;
                this.m_nWidth = this.calWidth(graphics);
            }
            return this.m_nWidth;
        }
        return 0;
    }

    public int countRightSibiling(int n) {
        int n2 = 0;
        while (n >= 0 && n < this.m_vEntries.size()) {
            TocEntry tocEntry = (TocEntry)this.m_vEntries.elementAt(n);
            if (tocEntry.getNextSpan() == -1) break;
            ++n2;
            n += tocEntry.getNextSpan() + 1;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private int getFirstVisibleEntryIndex(TocEntry var1_1, int var2_2, int var3_3) {
        var4_4 = null;
        while (true) {
            var4_4 = var1_1.getNextSibling();
            if (!var1_1.isStubEntry()) ** GOTO lbl9
            var1_1 = var4_4;
            if (var1_1 != null) continue;
            return -1;
lbl-1000:
            // 1 sources

            {
                var4_4 = var4_4.getNextSibling();
lbl9:
                // 2 sources

                ** while (var4_4 != null && var4_4.isStubEntry())
            }
lbl10:
            // 1 sources

            if (var1_1.getPosOffset() >= var2_2) break;
            if (var4_4 == null || var4_4.getPosOffset() > var2_2) {
                if (var4_4 != null && var4_4.getPosOffset() < var2_2 + var3_3) {
                    if (var1_1.getFirstChild() != null) {
                        var5_5 = this.getFirstVisibleEntryIndex(var1_1.getFirstChild(), var2_2, var3_3);
                        if (var5_5 != -1) {
                            return var5_5;
                        }
                        var1_1 = var4_4;
                        continue;
                    }
                    var1_1 = var4_4;
                    continue;
                }
                if (var1_1.getFirstChild() != null) {
                    return this.getFirstVisibleEntryIndex(var1_1.getFirstChild(), var2_2, var3_3);
                }
                return -1;
            }
            var1_1 = var4_4;
        }
        if (var1_1.getPosOffset() < var2_2 + var3_3) {
            return var1_1.getIndex();
        }
        return -1;
    }

    private boolean isEntryVisible(TocEntry tocEntry) {
        TocEntry tocEntry2 = tocEntry.getDirectParent();
        if (tocEntry2 != null) {
            if (!tocEntry2.isOpen()) {
                return false;
            }
            return this.isEntryVisible(tocEntry2);
        }
        return this.m_bVisible;
    }
}

