{ FILE:  editpkg.pas }



unit EditPkg;



{ ************************************************************************* }
{                                                                           }
{ NOTICE:  Most of the following code was written by Borland International. }
{          The code is for use by TP6.0 users.  Keep the copyright notice   }
{          intact!                                                          }
{                                                                           }
{          Turbo Pascal 6.0                                                 }
{          Turbo Vision Demo                                                }
{          Copyright (c) 1990 by Borland International                      }
{                                                                           }
{ This unit provides an interface to the NEWEDIT unit.  Specifically,       }
{ it initializes the buffers, contains all the editor dialogs, handles all  }
{ allocation and deallocation of the clipboard, and of course opens up      }
{ the appropriate edit window when requested.                               }
{                                                                           }
{ The major item I've changed here is how the "heap" is set up for          }
{ use by the editor buffers.  You can search for it using the HEAP          }
{ shown below.                                                              }
{                                                                           }
{ In addition, I've added a procedure to show how to close editor windows   }
{ for external file processing and then reopen them to continue editing.    }
{ Look for the CHKSPL label.  This label is also defined in NEDEMO and      }
{ NEWEDIT, for it requires coding through all three units.                  }
{                                                                           }
{ All other labels in this unit are defined in the NEWEDIT                  }
{ unit, they being mostly for dialog boxes and error messages.              }
{                                                                           }
{ There are additional minor things, like how to use typecasting to set     }
{ editor defaults when opening a window.  These aren't labeled.             }
{                                                                           }
{ Search   Description:                                                     }
{ ------   ------------                                                     }
{                                                                           }
{ HEAP   - Added a feature to allow maximum or minimum heap allocation      }
{          for use by the editors buffers.                                  }
{                                                                           }
{ SPLCHK - Shows how to close an edit window to process a file              }
{          (such as spell checking) and reopen the window when done.        }
{                                                                           }
{ Al Andersen - 02/29/92.                                                   }
{                                                                           }
{ ************************************************************************* }


{$O+,F+,X+,S-,D-}



interface



uses

  Objects,
  Drivers,
  Views,
  Dialogs,
  StdDlg,
  MsgBox,
  App,
  Memory,
  CmdFile,
  NewEdit;


VAR

  Clip_Window : NewEdit.PEditWindow;      { Object to hold the clip board. }



  { SPLCHK - Start. }

  procedure SpellIt;

  { SPLCHK - Stop. }

  procedure Deallocate_The_Clipboard;
  procedure Deallocate_The_Editor;

  procedure Initialize_The_Clipboard;
  procedure Initialize_The_Editor;

  function  Open_Editor (File_Name : Objects.FNameStr;
                         Visible   : Boolean) : NewEdit.PEditWindow;

  procedure Run_The_Editor;
  procedure Show_ClipBoard;



implementation


{ -------------------------------------------------------------------------- }



{ SPLCHK - Start. }



Procedure SpellIt;


  { ---------------------------------------------------------------------- }
  {                                                                        }
  { This procedure demonstrates how to close an editor window for external }
  { file processing, and then reopen the window to continue editing.  The  }
  { procedure assumes an external spell checking program will be used.     }
  {                                                                        }
  { ---------------------------------------------------------------------- }


VAR

  SpellFileName : Objects.FNameStr; { Determines what the filename is. }

begin


  { ----------------------------------------------------------- }
  {                                                             }
  { First we check to make sure that the current window is in   }
  { fact an editor window.  We need to do this so you don't run }
  { the spelling checker unless an edit window is being used.   }
  {                                                             }
  { ----------------------------------------------------------- }


  if typeof (Desktop^.Current^) = typeof (TEditWindow) then
    begin


      { --------------------------------------------------------- }
      {                                                           }
      { OK, now get the filename associated with the current edit }
      { window.  Then send a message to NewEdit.TFileEditor's     }
      { HandleEvent method to write the data to disk and close    }
      { the window.  You need to *REMOVE* the dialog and insert   }
      { your spell checking code in its place.  Last of all you   }
      { call Open_Editor to reopen your edit window.              }
      {                                                           }
      { --------------------------------------------------------- }


      SpellFileName := NewEdit.PEditWindow (Desktop^.Current)^.Editor^.FileName;

      Message (Desktop^.Current,
               Drivers.evCommand,
               NewEdit.cmSaveDone,
               nil);

      Msgbox.MessageBox (^C'Now your spellchecker does its thing.',
                         nil, MsgBox.mfInformation + MsgBox.mfOKButton);

      Open_Editor (SpellFileName, True);

    end;


end; { SpellIt }



{ SPLCHK - Stop. }



{ -------------------------------------------------------------------------- }

procedure Deallocate_The_Clipboard;


  { ----------------------------------------------------- }
  {                                                       }
  { This procedure disposes of the clipboard.  It is used }
  { by the NEDEMO program when saving a desktop file.     }
  {                                                       }
  { ----------------------------------------------------- }


begin

  if Clip_Window = nil then
    Exit;

  Dispose (NewEdit.Clipboard, Done);
  NewEdit.Clipboard := nil;
  Dispose (Clip_Window, Done);

end; { Deallocate_The_Clipboard }



{ -------------------------------------------------------------------------- }



procedure Deallocate_The_Editor;


  { --------------------------------------------------------- }
  {                                                           }
  { This procedure deallocates the editor buffer from memory. }
  {                                                           }
  { --------------------------------------------------------- }


begin

  MaxHeapSize := 0;
  EditorDialog := Nil;

end; { Deallocate_The_Editor }



{ -------------------------------------------------------------------------- }



procedure Initialize_The_Clipboard;



  { ----------------------------------------------------- }
  {                                                       }
  { Set up a clipboard so editor can cut and paste text.  }
  { We place this here because we also need to reallocate }
  { a new clipboard everytime we save a desktop to disk.  }
  {                                                       }
  { ----------------------------------------------------- }

var
  R: TRect;
begin
  clip_window := Nil;
  Desktop^.GetExtent(R);
  Clip_Window := New(PEditWindow, Init(R, '', wnNoNumber));
  if Application^.ValidView(Clip_Window) <> nil then
  begin
    Clip_Window^.Hide;
    Application^.InsertWindow(Clip_Window);
    Clipboard := Clip_Window^.Editor;
    Clipboard^.CanUndo := False;
  end;
end; { Initialize_The_Clipboard }



{ -------------------------------------------------------------------------- }



procedure Initialize_The_Editor;
  { This procedure sets aside a bit of memory for the editor buffers. }
begin
  { MaxHeapSize must be the first thing you do prior to using any heap }
  { This is stressed in the BP TV docs on there editor }
  MaxHeapSize := 8192;
  EditorDialog := StdEditorDialog;
end; { Initialize_The_Editor }



{ -------------------------------------------------------------------------- }



function Open_Editor (File_Name : Objects.FNameStr; Visible : Boolean) : NewEdit.PEditWindow;


  { ------------------------------------------------------- }
  {                                                         }
  { This is the actual function that opens up the edit view }
  { and places it on the desktop.                           }
  {                                                         }
  { ------------------------------------------------------- }


VAR

  P : Views.PView;
  R : TRect;

begin

  DeskTop^.GetExtent (R);
  P := Application^.ValidView (New (NewEdit.PEditWindow,
       Init (R, File_Name, wnNoNumber)));

  if P <> nil then
    begin

      if not Visible then
        begin
          P^.Hide;
          P^.Options := P^.Options and not Views.ofTileable;
        end
      else



        { ------------------------------------------------------------- }
        {                                                               }
        { This is a demonstration on how you can type cast variables    }
        { and thereby override their NEWEDIT defaults.  If you really   }
        { wanted to get fancy, you could add the appropriate parameters }
        { to the Open_Editor function call and thereby have different   }
        { defaults for each window.                                     }
        {                                                               }
        { ------------------------------------------------------------- }


        with NewEdit.PEditWindow (P)^ do
          begin
            Editor^.AutoIndent := True;
            Editor^.Word_Wrap := True;
            Editor^.Right_Margin := 76;
          end;

        Desktop^.Insert (P);

        Message (P, Drivers.evBroadcast, NewEdit.cmBludgeonStats, nil);

      end;

  Open_Editor := NewEdit.PEditWindow (P);


end; { Open_Editor }



{ -------------------------------------------------------------------------- }



procedure Run_The_Editor;


  { --------------------------------------------------------------- }
  {                                                                 }
  { This procedure is a "front end" to the Open_Editor function.    }
  { It brings up a dialog box that asks the user which file to use. }
  {                                                                 }
  { --------------------------------------------------------------- }


VAR

  D        : Dialogs.PDialog;
  FileName : Objects.FNameStr;

begin

  FileName := '*.*';

  D := new (StdDlg.PFileDialog, Init ('*.*', 'Edit A File',
            '~N~ame', StdDlg.fdOpenButton, 100));

  D^.HelpCtx := CmdFile.hcDName;

  if Application^.ExecuteDialog(D, @FileName) <> cmCancel then
    Open_Editor (FileName, True);

end; { Run_The_Editor }



{ -------------------------------------------------------------------------- }



procedure Show_ClipBoard;

begin

  Clip_Window^.Select;
  Clip_Window^.Show;


end; { Show_ClipBoard }



{ -------------------------------------------------------------------------- }



begin { EditPkg }

end. { Unit EditPkg }
