/*  new.h

    Access to operator new() and newhandler()

*/

#if !defined(__NEW_H)
#define __NEW_H

#ifndef __cplusplus
#error Must use C++ with new.h
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

typedef void (* new_handler)() ;
new_handler set_new_handler(new_handler);


void * operator new(size_t size);
void * operator new(size_t size, void *ptr);

void * operator new[](size_t size);
void * operator new[](size_t size, void *ptr);

void   operator delete  (void *);
void   operator delete[](void *);

#endif  /* __NEW_H */