#if !defined(__CONIO_H)
#define __CONIO_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#define _NOCURSOR      0
#define _SOLIDCURSOR   1
#define _NORMALCURSOR  2

struct text_info {
    unsigned char winleft;
    unsigned char wintop;
    unsigned char winright;
    unsigned char winbottom;
    unsigned char attribute;
    unsigned char normattr;
    unsigned char currmode;
    unsigned char screenheight;
    unsigned char screenwidth;
    unsigned char curx;
    unsigned char cury;
};

#if !defined(__COLORS)
#define __COLORS

enum COLORS {
    BLACK,          /* dark colors */
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,       /* light colors */
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE
};

#endif

#define BLINK       128 /* blink bit */

enum text_modes {  LASTMODE=-1,
                   BW40=0,
                   C40,
                   BW80,
                   C80,
                   MONO=7,
                   C4350=64 };

#ifdef __cplusplus
extern "C" {
#endif

void         _RTL_NORM clreol( void );
void         _RTL_NORM clrscr( void );
void         _RTL_NORM gotoxy( int __x, int __y );
int          _RTL_NORM getch( void );
int          _RTL_NORM getche( void );
int          _RTL_NORM kbhit( void );
int          _RTL_NORM putch( int __c );
int          _RTL_NORM wherex( void );
int          _RTL_NORM wherey( void );

unsigned char    _RTL_INTRINS inportb( unsigned __portid );
unsigned         _RTL_INTRINS inport ( unsigned __portid );
int              _RTL_INTRINS inp( unsigned __portid );
unsigned         _RTL_INTRINS inpw( unsigned __portid );
void             _RTL_INTRINS outportb( unsigned __portid, unsigned char __value );
void             _RTL_INTRINS outport ( unsigned __portid, unsigned __value );
int              _RTL_INTRINS outp( unsigned __portid, int __value );
unsigned         _RTL_INTRINS outpw( unsigned __portid, unsigned __value );

void         _RTL_NORM delline( void );
int          _RTL_NORM gettext( int __left, int __top,
                           int __right, int __bottom,
                           void *__destin);
void         _RTL_NORM gettextinfo (struct text_info *__r );
void         _RTL_NORM highvideo( void );
void         _RTL_NORM insline( void );
void         _RTL_NORM lowvideo( void );
int          _RTL_NORM movetext( int __left, int __top,
                            int __right, int __bottom,
                            int __destleft, int __desttop );
void         _RTL_NORM normvideo( void );
int          _RTL_NORM puttext( int __left, int __top,
                           int __right, int __bottom,
                           void *__source );
void         _RTL_NORM textattr( int __newattr );
void         _RTL_NORM textbackground( int __newcolor );
void         _RTL_NORM textcolor( int __newcolor );
void         _RTL_NORM textmode( int __newmode );
void         _RTL_NORM window( int __left, int __top, int __right, int __bottom);

void         _RTL_NORM _setcursortype( int __cur_t );
char *       _RTL_NORM cgets( char *__str );
int          _RTL_NORM cprintf( const char *__format, ... );
int          _RTL_NORM cputs( const char *__str );
int          _RTL_NORM cscanf( const char *__format, ... );
char *       _RTL_NORM getpass( const char *__prompt );
int          _RTL_NORM ungetch( int __ch );

#ifdef __cplusplus
}
#endif

#endif  /* __CONIO_H */