/*
 * this example displays all the (normal) files in the current directory
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dir.h>

/* files are listed here */
char *filelist[100];

/* a comparison routine for qsort */
int compare(char **a, char **b)
{
  return strcmp(*a,*b);
}
int main()
{
  int i,count= 0;
  struct ffblk data;

  /* find the first file */
  if (findfirst("*.*",&data,_A_NORMAL))
    printf("No files");
  else {
    /* we have one, put it in the list */
    filelist[count++] = strdup(data.ff_name);

    /* loop adding all remaining files to the list */
    while (!findnext(&data)) {
      filelist[count++] = strdup(data.ff_name);
      if (count > 99) {
        printf("too many files, truncating list");
        break;
      }
    }
    /* now sort the list */
    qsort(filelist,count,sizeof(char *),compare);

    /* and print it out */
    for (i=0; i < count; i++)
      printf("%s\n",filelist[i]);
  }
}