/*
 * PEAK-SEQ -- PREPROCESSING
 * Paper by Joel Rozowsky, et. al.
 * Coded in C by Theodore Gibson.
 * This module deals with sorting and output to the sgr files.
*/


#ifndef SGR_H
#define SGR_H


//-------------------------------------------------
// PUBLIC STRUCTURE DEFINITION
//-------------------------------------------------
/*
 * This structure holds an array of positions.
 * Ps is a pointer to this strucutre.
*/
typedef struct ps* Ps;


//-------------------------------------------------
// PUBLIC FUNCTION PROTOTYPES
//-------------------------------------------------
/*
 * This function allocates memory for and initializes a new
 * array of Ps structures, including one for each chromosome.
 * Outputs a pointer to the array.
*/
Ps* newPsArray( void );

/*
 * This function inserts a read into the pos array corresponding
 * to its chromosome.  It inserts both the the start and stop
 * locations of the read separately.
 * ps: a pointer to the structure containing the pos array for the
 *	chromosome containing this read.
 * pos: the position of this read on this chromosome.
 * score: the score indicating whether this is a start or stop of a read.
*/
void insertPos( Ps ps, const int pos, const int score );

/*
 * This function prints to the sgr files.
 * array: a pointer to the array of ps structures.
*/
void fprintfSGR( Ps* array );


#endif
