/*
 * PEAK-SEQ -- PREPROCESSING
 * Paper by Joel Rozowsky, et. al.
 * Coded in C by Theodore Gibson.
 * This module deals with input/output concerns.
*/

#ifndef IO_H
#define IO_H


//-------------------------------------------------
// PUBLIC TYPE DECLARATION
//-------------------------------------------------
// This type declaration aids in the program's readability.
typedef char* String;


//-------------------------------------------------
// PUBLIC FUNCTION PROTOTYPES
//-------------------------------------------------
/*
 * This function converts the string from chr1 to chrM to an
 * integer that represents which chromosome it is on.
 * The X chromosome is stored as chromosome 23, Y as 24, and M as 25.
 * If there is a letter other than X, Y, or M, -1 is outputted, denoting failure.
 * cname: the string representation of the chromosome in the format chr#.
 * Outputs the chromosome number.
*/
int getCnum( const String cname );

/*
 * This function converts a chromosome number to the string chr1 to chrM.
 * If the number is greater than 25, this function returns a NULL pointer,
 * denoting failure.
 * cnum: the number of this chromosome.
 * Outputs the string corresponding to this chromosome.
*/
String getCname( const int cnum );

/*
 * This function moves to the end of the current line before moving to
 * the next line in the file.
 * in: the file being read.
*/
void getNewline( FILE* in );


#endif
