/*
 * PeakSeq
 * Version 1.01
 * Paper by Joel Rozowsky, et. al.
 * Coded in C by Theodore Gibson.
 * simulator.h
 * This module deals with the simulation for one set of parameters.
 */


#ifndef FILTER_SIMULATOR_H
#define FILTER_SIMULATOR_H


#include "window.h"


//----------------------------------------------------------------------------
// PUBLIC STRUCTURE DEFINITION
//----------------------------------------------------------------------------
/*
 * Thresh is a pointer to the structure that is used while computing the
 * 	statistics for all thresholds at once for a given simulation.  It stores
 * 	all information about a threshold that differs from the other thresholds.
 */
typedef struct thresh* Thresh;


//----------------------------------------------------------------------------
// PUBLIC FUNCTION PROTOTYPES
//----------------------------------------------------------------------------
/*
 * This function allocates memory for a new array of thresh structures.
 * Outputs a pointer to the array.
 */
Thresh* newThreshArray( void );

/*
 * This function runs the simulator for a given window.
 * w: a pointer to the window structure containing all data about this window.
 * ta: a pointer to the thresh array storing the data.
 */
void simulator( Window w, Thresh* ta );

/*
 * This function finds the qualifying threshold for a given minimum FDR.
 * w: a pointer to the window structure containing the data.
 * ta: the array of thresh structures containing the data from the simulation.
 * fdrp: a pointer to the field that will contain the fdr of this threshold.
 * Outputs the threshold.
 */
int findThresh( Window w, Thresh* ta, long double* fdrp );

/*
 * This function frees all memory allocated to a thresh array.
 * ta: a pointer to the array to be freed.
 */
void freeThreshArray( Thresh* ta );

#endif	/* SIMULATOR_H */
