/*
 * PeakSeq
 * Version 1.01
 * Paper by Joel Rozowsky, et. al.
 * Coded in C by Theodore Gibson.
 * random.h
 * This interface deals with creating random numbers.
 */

// Code was copied and comments were paraphrased from the following computer
// science textbook:
//	Roberts, Eric. Programming Abstractions in C: a second course in computer
//	science.  Reading, Massachusetts: Addison Wesley Longman, Inc., 1998,
//	p. 112-113.


#ifndef RANDOM_H
#define RANDOM_H


//----------------------------------------------------------------------------
// PUBLIC FUNCTION PROTOTYPES
//----------------------------------------------------------------------------
/*
 * This function initializes the random-number generator so that its results
 * 	are unpredictable and different between runs of the program.  Otherwise
 * 	every run of the program would produce the same exact results.
*/
void Randomize( void );

/*
 * This function returns a random integer in the range low to high, inclusive.
 * low: the lower bound of the range, inclusive.
 * high: the upper bound of the range, inclusive.
 * Outputs the randomly-generated integer.
*/
int RandomInteger( const int low, const int high );


#endif	/* RANDOM_H	*/
