/*
 * PeakSeq
 * Version 1.01
 * Paper by Joel Rozowsky, et. al.
 * Coded in C by Theodore Gibson.
 * random.c
 * This interface deals with creating random numbers.
 */

// Code was copied and comments were paraphrased from the following computer
// science textbook:
//	Roberts, Eric. Programming Abstractions in C: a second course in computer
//	science.  Reading, Massachusetts: Addison Wesley Longman, Inc., 1998,
//	p. 112-113.


#include <stdlib.h>
#include <time.h>
#include "random.h"


//----------------------------------------------------------------------------
// PUBLIC FUNCTIONS
//----------------------------------------------------------------------------
void Randomize( void )
{
	srand( (int) time(NULL) );
}

int RandomInteger( const int low, const int high )
{
	int k;
	double d;

	// This line normalizes the randomly-generated value to a double in the
	// interval [0,1).
	d = (double) rand() / ((double) RAND_MAX + 1);
	// This line scales the decimal number to a number in the desired range
	// size and truncates it to an integral value.
	k = (int) (d * (high - low + 1));
	// This line adds the lower bound of the range to the value and returns
	// the randomly generated value.
	return (low + k);
}
