
package org.jfree.chart.event.junit;

import org.jfree.chart.event.*;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.chart.plot.junit.HCPlotTests;
import java.awt.*;


import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * A collection of tests for the org.jfree.chart.event package.
 * <P>
 * These tests can be run using JUnit (http://www.junit.org).
 */
public class EventPackageTests extends TestCase {

    /**
     * Returns a test suite to the JUnit test runner.
     *
     * @return The test suite.
     */
    public static Test suite() {
	TestSuite suite = new TestSuite("org.jfree.chart.event"); 
       suite.addTestSuite(SelectionChangeEventTests.class);
	return new TestSuite(EventPackageTests.class);
    }

    /**
     * Constructs the test suite.
     *
     * @param name  the suite name.
     */
    public EventPackageTests(String name) {
	
        super(name);

    }

    /**
     * Runs the test suite using JUnit's text-based runner.
     * 
     * @param args  ignored.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    /**
     * Test event constructors.
     */
    public void testEvents() throws Exception {

	HCPlot plot = new HCPlot(HCPlotTests.createDataset(2,3,true,true));
	HCTreeNodeInfo info = plot.getRowClusteringInfo().getRootNode();
	
	SelectionChangeEvent e1;
	ClusteringTreeChangeEvent e2;

	e1 = new SelectionChangeEvent(plot,plot.getSelection());
	e2 = new ClusteringTreeChangeEvent(plot,info);

	assertTrue(e2.getTreeNodeInfo() == info);
	
	Rectangle rct = e1.getOldSelection();

    }

}
