/* ======================================================================= 
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.entity;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Point;

import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.chart.entity.ChartEntity;

/**
 * A chart entity for nodes of clustering trees used in {@link org.jfree.chart.plot.HCPlot}.
 * @author  viski project
 */
public class HCTreeNodeEntity extends ChartEntity {

    /** The subtree of this branch. */
    private Rectangle subTreeArea;
    /** The center point of this treenode. */
    private Point center;
    /** The node information. */
    private HCTreeNodeInfo node;

    /**
     * Creates a new treenode entity.
     *
     * @param area  the area.
     * @param toolTipText  the tool tip text.
     * @param urlText  the URL text for a HTML imagemap.
     * @param center  the center point.
     * @param subTreeArea  the area of the subtree.
     * @param node  the nodeinformation.
     */     
    public HCTreeNodeEntity(
	    Shape area,
	    String toolTipText,
	    String urlText,
	    Point center,
	    Rectangle subTreeArea,
	    HCTreeNodeInfo node
	    ) {
        super(area, toolTipText, urlText);

	this.subTreeArea = subTreeArea;
	this.center = center;
	this.node = node;

    }

    /** 
     * Returns the area of the subtree.
     *
     * @return  The area of the subtree.
     */
    public Rectangle getSubTreeArea() {
	return this.subTreeArea;
    }

    /**
     * Returns the center point.
     *
     * @return  The center point.
     */
    public Point getCenter() {
	return this.center;
    }
   
    /**
     * Returns the node information.
     *
     * @return  The node information.
     */
    public HCTreeNodeInfo getHCTreeNodeInfo() {
	return this.node;
    }
}
