/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import com.sun.management.OperatingSystemMXBean;
import fi.csc.microarray.messaging.message.ServerStatusMessage;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;

public class SystemMonitorUtil {
    public static final String CPU_LOAD = "Load";
    public static final String CPU_CORES = "Cores";
    public static final String CPU_PERCENTS = "Cpu";
    public static final String MEM_USED = "Memory used";
    public static final String MEM_TOTAL = "Memory total";
    public static final String MEM_PERCENTS = "Memory";
    public static final String DISK_USED = "Disk used";
    public static final String DISK_TOTAL = "Disk total";
    public static final String DISK_PERCENTS = "Disk space";

    public static String bytesToMegas(long bytes) {
        float megas = (float)bytes / 1024.0f / 1024.0f;
        return SystemMonitorUtil.round(megas);
    }

    public static String bytesToGigas(long bytes) {
        float gigas = (float)bytes / 1024.0f / 1024.0f / 1024.0f;
        return SystemMonitorUtil.round1(gigas);
    }

    public static String round(float f) {
        StringWriter s = new StringWriter();
        new PrintWriter(s).printf("%.0f", Float.valueOf(f));
        return s.toString();
    }

    public static String round1(float f) {
        StringWriter s = new StringWriter();
        new PrintWriter(s).printf("%.1f", Float.valueOf(f));
        return s.toString();
    }

    public static long getUsed() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static String getMemInfo() {
        long used = SystemMonitorUtil.getUsed();
        String usedS = SystemMonitorUtil.bytesToMegas(used);
        String maxS = SystemMonitorUtil.bytesToMegas(Runtime.getRuntime().maxMemory());
        return usedS + "M / " + maxS + "M";
    }

    public static ServerStatusMessage getSystemStats(File disk) {
        double load = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        int cores = Runtime.getRuntime().availableProcessors();
        int cpuPercents = (int)(load / (double)cores * 100.0);
        java.lang.management.OperatingSystemMXBean mxbean = ManagementFactory.getOperatingSystemMXBean();
        OperatingSystemMXBean sunmxbean = (OperatingSystemMXBean)mxbean;
        long memFree = sunmxbean.getFreePhysicalMemorySize();
        long memTotal = sunmxbean.getTotalPhysicalMemorySize();
        long memUsed = memTotal - memFree;
        int memPercents = (int)((float)memUsed / (float)memTotal * 100.0f);
        long diskTotal = disk.getTotalSpace();
        long diskFree = disk.getFreeSpace();
        long diskUsed = diskTotal - diskFree;
        int diskPercents = (int)((float)diskUsed / (float)diskTotal * 100.0f);
        ServerStatusMessage statusMessage = new ServerStatusMessage(load, cores, cpuPercents, memUsed, memTotal, memPercents, diskUsed, diskTotal, diskPercents);
        return statusMessage;
    }
}

