/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.LockableServiceSupport;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.broker.jmx.AnnotatedMBean;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.PersistenceAdapterView;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.store.JournaledStore;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.SharedFileLocker;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionIdTransformer;
import org.apache.activemq.store.TransactionIdTransformerAware;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.store.kahadb.data.KahaLocalTransactionId;
import org.apache.activemq.store.kahadb.data.KahaTransactionInfo;
import org.apache.activemq.store.kahadb.data.KahaXATransactionId;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.ServiceStopper;

public class KahaDBPersistenceAdapter
extends LockableServiceSupport
implements PersistenceAdapter,
JournaledStore,
TransactionIdTransformerAware {
    private final KahaDBStore letter = new KahaDBStore();

    public void beginTransaction(ConnectionContext context) throws IOException {
        this.letter.beginTransaction(context);
    }

    public void checkpoint(boolean sync) throws IOException {
        this.letter.checkpoint(sync);
    }

    public void commitTransaction(ConnectionContext context) throws IOException {
        this.letter.commitTransaction(context);
    }

    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        return this.letter.createQueueMessageStore(destination);
    }

    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        return this.letter.createTopicMessageStore(destination);
    }

    public TransactionStore createTransactionStore() throws IOException {
        return this.letter.createTransactionStore();
    }

    public void deleteAllMessages() throws IOException {
        this.letter.deleteAllMessages();
    }

    public Set<ActiveMQDestination> getDestinations() {
        return this.letter.getDestinations();
    }

    public long getLastMessageBrokerSequenceId() throws IOException {
        return this.letter.getLastMessageBrokerSequenceId();
    }

    public long getLastProducerSequenceId(ProducerId id) throws IOException {
        return this.letter.getLastProducerSequenceId(id);
    }

    public void removeQueueMessageStore(ActiveMQQueue destination) {
        this.letter.removeQueueMessageStore(destination);
    }

    public void removeTopicMessageStore(ActiveMQTopic destination) {
        this.letter.removeTopicMessageStore(destination);
    }

    public void rollbackTransaction(ConnectionContext context) throws IOException {
        this.letter.rollbackTransaction(context);
    }

    public void setBrokerName(String brokerName) {
        this.letter.setBrokerName(brokerName);
    }

    public void setUsageManager(SystemUsage usageManager) {
        this.letter.setUsageManager(usageManager);
    }

    public long size() {
        return this.letter.size();
    }

    public void doStart() throws Exception {
        this.letter.start();
        if (this.brokerService != null && this.brokerService.isUseJmx()) {
            PersistenceAdapterView view = new PersistenceAdapterView((PersistenceAdapter)this);
            view.setInflightTransactionViewCallable((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return KahaDBPersistenceAdapter.this.letter.getTransactions();
                }
            });
            view.setDataViewCallable((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return KahaDBPersistenceAdapter.this.letter.getJournal().getFileMap().keySet().toString();
                }
            });
            AnnotatedMBean.registerMBean((ManagementContext)this.brokerService.getManagementContext(), (Object)view, (ObjectName)BrokerMBeanSupport.createPersistenceAdapterName((String)this.brokerService.getBrokerObjectName().toString(), (String)this.toString()));
        }
    }

    public void doStop(ServiceStopper stopper) throws Exception {
        this.letter.stop();
        if (this.brokerService != null && this.brokerService.isUseJmx()) {
            ObjectName brokerObjectName = this.brokerService.getBrokerObjectName();
            this.brokerService.getManagementContext().unregisterMBean(BrokerMBeanSupport.createPersistenceAdapterName((String)brokerObjectName.toString(), (String)this.toString()));
        }
    }

    public int getJournalMaxFileLength() {
        return this.letter.getJournalMaxFileLength();
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.letter.setJournalMaxFileLength(journalMaxFileLength);
    }

    public void setMaxFailoverProducersToTrack(int maxFailoverProducersToTrack) {
        this.letter.setMaxFailoverProducersToTrack(maxFailoverProducersToTrack);
    }

    public int getMaxFailoverProducersToTrack() {
        return this.letter.getMaxFailoverProducersToTrack();
    }

    public void setFailoverProducersAuditDepth(int failoverProducersAuditDepth) {
        this.letter.setFailoverProducersAuditDepth(failoverProducersAuditDepth);
    }

    public int getFailoverProducersAuditDepth() {
        return this.letter.getFailoverProducersAuditDepth();
    }

    public long getCheckpointInterval() {
        return this.letter.getCheckpointInterval();
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.letter.setCheckpointInterval(checkpointInterval);
    }

    public long getCleanupInterval() {
        return this.letter.getCleanupInterval();
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.letter.setCleanupInterval(cleanupInterval);
    }

    public int getIndexWriteBatchSize() {
        return this.letter.getIndexWriteBatchSize();
    }

    public void setIndexWriteBatchSize(int indexWriteBatchSize) {
        this.letter.setIndexWriteBatchSize(indexWriteBatchSize);
    }

    public int getJournalMaxWriteBatchSize() {
        return this.letter.getJournalMaxWriteBatchSize();
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.letter.setJournalMaxWriteBatchSize(journalMaxWriteBatchSize);
    }

    public boolean isEnableIndexWriteAsync() {
        return this.letter.isEnableIndexWriteAsync();
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.letter.setEnableIndexWriteAsync(enableIndexWriteAsync);
    }

    public File getDirectory() {
        return this.letter.getDirectory();
    }

    public void setDirectory(File dir) {
        this.letter.setDirectory(dir);
    }

    public boolean isEnableJournalDiskSyncs() {
        return this.letter.isEnableJournalDiskSyncs();
    }

    public void setEnableJournalDiskSyncs(boolean enableJournalDiskSyncs) {
        this.letter.setEnableJournalDiskSyncs(enableJournalDiskSyncs);
    }

    public int getIndexCacheSize() {
        return this.letter.getIndexCacheSize();
    }

    public void setIndexCacheSize(int indexCacheSize) {
        this.letter.setIndexCacheSize(indexCacheSize);
    }

    public boolean isIgnoreMissingJournalfiles() {
        return this.letter.isIgnoreMissingJournalfiles();
    }

    public void setIgnoreMissingJournalfiles(boolean ignoreMissingJournalfiles) {
        this.letter.setIgnoreMissingJournalfiles(ignoreMissingJournalfiles);
    }

    public boolean isChecksumJournalFiles() {
        return this.letter.isChecksumJournalFiles();
    }

    public boolean isCheckForCorruptJournalFiles() {
        return this.letter.isCheckForCorruptJournalFiles();
    }

    public void setChecksumJournalFiles(boolean checksumJournalFiles) {
        this.letter.setChecksumJournalFiles(checksumJournalFiles);
    }

    public void setCheckForCorruptJournalFiles(boolean checkForCorruptJournalFiles) {
        this.letter.setCheckForCorruptJournalFiles(checkForCorruptJournalFiles);
    }

    public void setBrokerService(BrokerService brokerService) {
        super.setBrokerService(brokerService);
        this.letter.setBrokerService(brokerService);
    }

    public boolean isArchiveDataLogs() {
        return this.letter.isArchiveDataLogs();
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.letter.setArchiveDataLogs(archiveDataLogs);
    }

    public File getDirectoryArchive() {
        return this.letter.getDirectoryArchive();
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.letter.setDirectoryArchive(directoryArchive);
    }

    public boolean isConcurrentStoreAndDispatchQueues() {
        return this.letter.isConcurrentStoreAndDispatchQueues();
    }

    public void setConcurrentStoreAndDispatchQueues(boolean concurrentStoreAndDispatch) {
        this.letter.setConcurrentStoreAndDispatchQueues(concurrentStoreAndDispatch);
    }

    public boolean isConcurrentStoreAndDispatchTopics() {
        return this.letter.isConcurrentStoreAndDispatchTopics();
    }

    public void setConcurrentStoreAndDispatchTopics(boolean concurrentStoreAndDispatch) {
        this.letter.setConcurrentStoreAndDispatchTopics(concurrentStoreAndDispatch);
    }

    public int getMaxAsyncJobs() {
        return this.letter.getMaxAsyncJobs();
    }

    public void setMaxAsyncJobs(int maxAsyncJobs) {
        this.letter.setMaxAsyncJobs(maxAsyncJobs);
    }

    @Deprecated
    public void setDatabaseLockedWaitDelay(int databaseLockedWaitDelay) throws IOException {
        this.getLocker().setLockAcquireSleepInterval((long)databaseLockedWaitDelay);
    }

    public boolean getForceRecoverIndex() {
        return this.letter.getForceRecoverIndex();
    }

    public void setForceRecoverIndex(boolean forceRecoverIndex) {
        this.letter.setForceRecoverIndex(forceRecoverIndex);
    }

    public boolean isArchiveCorruptedIndex() {
        return this.letter.isArchiveCorruptedIndex();
    }

    public void setArchiveCorruptedIndex(boolean archiveCorruptedIndex) {
        this.letter.setArchiveCorruptedIndex(archiveCorruptedIndex);
    }

    public float getIndexLFUEvictionFactor() {
        return this.letter.getIndexLFUEvictionFactor();
    }

    public void setIndexLFUEvictionFactor(float indexLFUEvictionFactor) {
        this.letter.setIndexLFUEvictionFactor(indexLFUEvictionFactor);
    }

    public boolean isUseIndexLFRUEviction() {
        return this.letter.isUseIndexLFRUEviction();
    }

    public void setUseIndexLFRUEviction(boolean useIndexLFRUEviction) {
        this.letter.setUseIndexLFRUEviction(useIndexLFRUEviction);
    }

    public void setEnableIndexDiskSyncs(boolean diskSyncs) {
        this.letter.setEnableIndexDiskSyncs(diskSyncs);
    }

    public boolean isEnableIndexDiskSyncs() {
        return this.letter.isEnableIndexDiskSyncs();
    }

    public void setEnableIndexRecoveryFile(boolean enable) {
        this.letter.setEnableIndexRecoveryFile(enable);
    }

    public boolean isEnableIndexRecoveryFile() {
        return this.letter.isEnableIndexRecoveryFile();
    }

    public void setEnableIndexPageCaching(boolean enable) {
        this.letter.setEnableIndexPageCaching(enable);
    }

    public boolean isEnableIndexPageCaching() {
        return this.letter.isEnableIndexPageCaching();
    }

    public KahaDBStore getStore() {
        return this.letter;
    }

    public KahaTransactionInfo createTransactionInfo(TransactionId txid) {
        if (txid == null) {
            return null;
        }
        KahaTransactionInfo rc = new KahaTransactionInfo();
        if (txid.isLocalTransaction()) {
            LocalTransactionId t = (LocalTransactionId)txid;
            KahaLocalTransactionId kahaTxId = new KahaLocalTransactionId();
            kahaTxId.setConnectionId(t.getConnectionId().getValue());
            kahaTxId.setTransactionId(t.getValue());
            rc.setLocalTransactionId(kahaTxId);
        } else {
            XATransactionId t = (XATransactionId)txid;
            KahaXATransactionId kahaTxId = new KahaXATransactionId();
            kahaTxId.setBranchQualifier(new Buffer(t.getBranchQualifier()));
            kahaTxId.setGlobalTransactionId(new Buffer(t.getGlobalTransactionId()));
            kahaTxId.setFormatId(t.getFormatId());
            rc.setXaTransactionId(kahaTxId);
        }
        return rc;
    }

    public Locker createDefaultLocker() throws IOException {
        SharedFileLocker locker = new SharedFileLocker();
        locker.configure((PersistenceAdapter)this);
        return locker;
    }

    public void init() throws Exception {
    }

    public String toString() {
        String path = this.getDirectory() != null ? this.getDirectory().getAbsolutePath() : "DIRECTORY_NOT_SET";
        return "KahaDBPersistenceAdapter[" + path + "]";
    }

    public void setTransactionIdTransformer(TransactionIdTransformer transactionIdTransformer) {
        this.getStore().setTransactionIdTransformer(transactionIdTransformer);
    }
}

