/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.tag.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.icepdf.core.tag.TagState;
import org.icepdf.core.tag.TaggedDocument;
import org.icepdf.core.tag.TaggedImage;
import org.icepdf.core.tag.query.And;
import org.icepdf.core.tag.query.DocumentResult;
import org.icepdf.core.tag.query.Expression;
import org.icepdf.core.tag.query.Function;
import org.icepdf.core.tag.query.Not;
import org.icepdf.core.tag.query.Operator;
import org.icepdf.core.tag.query.Or;
import org.icepdf.core.tag.query.ParseException;
import org.icepdf.core.tag.query.Substring;

public class Querior {
    public static Expression parse(String[] unparsedQuery) throws ParseException {
        int len = unparsedQuery == null ? 0 : unparsedQuery.length;
        Object[] parsedQuery = new Object[len];
        for (int i = 0; i < len; ++i) {
            Operator op;
            if (unparsedQuery[i].equals("img:and")) {
                op = new And();
                op.setScope(Operator.SCOPE_IMAGE);
                parsedQuery[i] = op;
                continue;
            }
            if (unparsedQuery[i].equals("tag:and")) {
                op = new And();
                op.setScope(Operator.SCOPE_TAG);
                parsedQuery[i] = op;
                continue;
            }
            if (unparsedQuery[i].equals("img:or")) {
                op = new Or();
                op.setScope(Operator.SCOPE_IMAGE);
                parsedQuery[i] = op;
                continue;
            }
            if (unparsedQuery[i].equals("tag:or")) {
                op = new Or();
                op.setScope(Operator.SCOPE_TAG);
                parsedQuery[i] = op;
                continue;
            }
            if (unparsedQuery[i].equals("img:not")) {
                op = new Not();
                op.setScope(Operator.SCOPE_IMAGE);
                parsedQuery[i] = op;
                continue;
            }
            if (unparsedQuery[i].equals("tag:not")) {
                op = new Not();
                op.setScope(Operator.SCOPE_TAG);
                parsedQuery[i] = op;
                continue;
            }
            parsedQuery[i] = unparsedQuery[i].equals("substring") ? new Substring() : unparsedQuery[i];
        }
        int numTokensParsed = Querior.rpnParse(parsedQuery, 0);
        if (numTokensParsed != parsedQuery.length) {
            throw new ParseException("Number of tokens given: " + parsedQuery.length + ", number of tokens parsed: " + numTokensParsed);
        }
        String desc = ((Expression)parsedQuery[0]).describe(0);
        System.out.println(desc);
        return (Expression)parsedQuery[0];
    }

    private static int rpnParse(Object[] parsedQuery, int position) throws ParseException {
        Object curr = parsedQuery[position];
        int tokens = 1;
        if (curr instanceof Expression) {
            int numArgs = ((Expression)curr).getArgumentCount();
            ArrayList<Integer> args = new ArrayList<Integer>(numArgs);
            for (int a = 0; a < numArgs; ++a) {
                int currArgIndex = position + tokens;
                if (currArgIndex >= parsedQuery.length) {
                    throw new ParseException("Token at position " + position + " has argument " + (a + 1) + " of " + numArgs + " which is calculated to be at position " + currArgIndex + ", which beyond the parsed list of query tokens");
                }
                tokens += Querior.rpnParse(parsedQuery, currArgIndex);
                args.add(new Integer(currArgIndex));
            }
            if (curr instanceof Operator) {
                Operator op = (Operator)curr;
                Expression[] eargs = new Expression[numArgs];
                for (int a = 0; a < numArgs; ++a) {
                    Integer index = (Integer)args.get(a);
                    Object arg = parsedQuery[index];
                    if (!(arg instanceof Expression)) {
                        throw new ParseException("Token at position " + position + " has argument " + (a + 1) + " of " + numArgs + ", calculated to be at position " + index + ", which is expected to be an expression token, but is instead a literal string: " + arg);
                    }
                    eargs[a] = (Expression)arg;
                }
                op.setChildExpressions(eargs);
            } else if (curr instanceof Function) {
                Function func = (Function)curr;
                String[] sargs = new String[numArgs];
                for (int a = 0; a < numArgs; ++a) {
                    Integer index = (Integer)args.get(a);
                    Object arg = parsedQuery[index];
                    if (arg instanceof Expression) {
                        throw new ParseException("Token at position " + position + " has argument " + (a + 1) + " of " + numArgs + ", calculated to be at position " + index + ", which is expected to be literal string, but is instead an expression token: " + arg);
                    }
                    sargs[a] = arg.toString();
                }
                func.setArguments(sargs);
            }
        }
        return tokens;
    }

    public static List search(TagState state, Expression queryRoot) {
        int docCount = 0;
        int imgCount = 0;
        int tagCount = 0;
        ArrayList<DocumentResult> results = new ArrayList<DocumentResult>(32);
        List docs = state.getDocuments();
        Iterator docIt = docs.iterator();
        while (docIt.hasNext()) {
            ++docCount;
            DocumentResult docRes = null;
            TaggedDocument td = (TaggedDocument)docIt.next();
            List images = td.getImages();
            Iterator imIt = images.iterator();
            while (imIt.hasNext()) {
                ++imgCount;
                boolean imageInResults = false;
                TaggedImage ti = (TaggedImage)imIt.next();
                List tags = ti.getTags();
                Iterator tagIt = tags.iterator();
                while (tagIt.hasNext()) {
                    ++tagCount;
                    String tag = (String)tagIt.next();
                    if (!queryRoot.matches(td, ti, tag)) continue;
                    if (docRes == null) {
                        docRes = new DocumentResult(td, ti);
                        imageInResults = true;
                        results.add(docRes);
                        continue;
                    }
                    if (imageInResults) continue;
                    docRes.addImage(ti);
                    imageInResults = true;
                }
            }
        }
        System.out.println("Searched " + docCount + " documents, " + imgCount + " images, " + tagCount + " tags.  Found " + results.size() + " matching documents.");
        return results;
    }
}

