/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserSettings;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import net.sf.samtools.SAMRecord;

public class BamUtils {
    public static Strand getStrand(SAMRecord record, GBrowserSettings.CoverageType coverageType) {
        if (coverageType == GBrowserSettings.CoverageType.STRAND) {
            if (record.getReadNegativeStrandFlag()) {
                return Strand.REVERSE;
            }
            return Strand.FORWARD;
        }
        if (coverageType == GBrowserSettings.CoverageType.STRAND_XS) {
            char xs = record.getCharacterAttribute("XS").charValue();
            if (xs == '+') {
                return Strand.FORWARD;
            }
            if (xs == '-') {
                return Strand.REVERSE;
            }
        }
        return null;
    }
}

