/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.admin;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.SuccessMessageListener;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.admin.ServerAdminAPI;
import fi.csc.microarray.messaging.admin.StorageAggregate;
import fi.csc.microarray.messaging.admin.StorageEntry;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.ParameterMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import fi.csc.microarray.util.Strings;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class StorageAdminAPI
extends ServerAdminAPI {
    private static final Logger logger = Logger.getLogger(StorageAdminAPI.class);

    public StorageAdminAPI(MessagingEndpoint endpoint) throws IOException, ConfigurationLoader.IllegalConfigurationException, MicroarrayException, JMSException {
        super(Topics.Name.FILEBROKER_ADMIN_TOPIC, endpoint);
    }

    public Long[] getStorageUsage() throws JMSException, InterruptedException {
        StorageTotalsMessageListener listener = new StorageTotalsMessageListener();
        return listener.query();
    }

    public List<StorageEntry> listStorageUsageOfSessions(String username) throws JMSException, InterruptedException {
        StorageEntryMessageListener listener = new StorageEntryMessageListener();
        listener.query(this.getTopic(), username);
        return listener.getEntries();
    }

    public List<StorageAggregate> listStorageUsageOfUsers() throws JMSException, InterruptedException {
        StorageAggregateMessageListener listener = new StorageAggregateMessageListener();
        return listener.query();
    }

    public void deleteRemoteSession(String sessionID) throws JMSException, MicroarrayException {
        SuccessMessageListener replyListener = new SuccessMessageListener();
        CommandMessage removeRequestMessage = new CommandMessage("remove-session");
        removeRequestMessage.addNamedParameter("session-uuid", sessionID);
        this.getTopic().sendReplyableMessage(removeRequestMessage, replyListener);
        SuccessMessage reply = replyListener.waitForReply(30L, TIMEOUT_UNIT);
        this.checkSuccessMessage(reply, "delete session");
    }

    private class StorageAggregateMessageListener
    extends TempTopicMessagingListenerBase {
        private CountDownLatch latch;
        private List<StorageAggregate> entries;

        private StorageAggregateMessageListener() {
        }

        public List<StorageAggregate> query() throws JMSException, InterruptedException {
            this.latch = new CountDownLatch(1);
            try {
                CommandMessage request = new CommandMessage("get-storage-usage-by-user");
                StorageAdminAPI.this.getTopic().sendReplyableMessage(request, this);
                this.latch.await(30L, ServerAdminAPI.TIMEOUT_UNIT);
                List<StorageAggregate> list = this.entries;
                return list;
            }
            finally {
                this.cleanUp();
            }
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ParameterMessage resultMessage = (ParameterMessage)msg;
            String namesString = resultMessage.getNamedParameter("username-list");
            String sizesString = resultMessage.getNamedParameter("size-list");
            String[] names = namesString.split("\t");
            String[] sizes = sizesString.split("\t");
            this.entries = new LinkedList<StorageAggregate>();
            for (int i = 0; i < names.length && i < sizes.length; ++i) {
                StorageAggregate entry = new StorageAggregate();
                entry.setUsername(names[i]);
                entry.setSize(Long.parseLong(sizes[i]));
                this.entries.add(entry);
            }
            this.latch.countDown();
        }
    }

    public static class StorageEntryMessageListener
    extends TempTopicMessagingListenerBase {
        private List<StorageEntry> entries;
        private long quota;
        private long quotaWarning;
        private CountDownLatch latch;
        private long storageUsage;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void query(MessagingTopic topic, String username) throws JMSException, InterruptedException {
            try {
                this.latch = new CountDownLatch(1);
                CommandMessage request = new CommandMessage("get-sessions-for-user");
                if (username != null) {
                    request.addNamedParameter("username", username);
                }
                topic.sendReplyableMessage(request, this);
                this.latch.await(30L, ServerAdminAPI.TIMEOUT_UNIT);
            }
            finally {
                this.cleanUp();
            }
        }

        public List<StorageEntry> getEntries() {
            return this.entries;
        }

        public long getQuota() {
            return this.quota;
        }

        public long getQuotaWarning() {
            return this.quotaWarning;
        }

        public long getStorageUsage() {
            return this.storageUsage;
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ParameterMessage resultMessage = (ParameterMessage)msg;
            String usernamesString = resultMessage.getNamedParameter("username-list");
            String namesString = resultMessage.getNamedParameter("session-name-list");
            String sizesString = resultMessage.getNamedParameter("size-list");
            String datesString = resultMessage.getNamedParameter("date-list");
            String idsString = resultMessage.getNamedParameter("session-uuid-list");
            String quotaString = resultMessage.getNamedParameter("quota");
            String quotaWarningString = resultMessage.getNamedParameter("quota-warning");
            String storageUsageString = resultMessage.getNamedParameter("file-size");
            String[] usernames = Strings.splitUnlessEmpty(usernamesString, "\t");
            String[] names = Strings.splitUnlessEmpty(namesString, "\t");
            String[] sizes = Strings.splitUnlessEmpty(sizesString, "\t");
            String[] dates = Strings.splitUnlessEmpty(datesString, "\t");
            String[] ids = Strings.splitUnlessEmpty(idsString, "\t");
            DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
            this.entries = new LinkedList<StorageEntry>();
            for (int i = 0; i < names.length; ++i) {
                StorageEntry entry = new StorageEntry();
                entry.setDate(dateTimeFormatter.parseDateTime(dates[i]).toDate());
                entry.setUsername(usernames[i]);
                entry.setSize(Long.parseLong(sizes[i]));
                entry.setName(names[i]);
                entry.setID(ids[i]);
                this.entries.add(entry);
            }
            this.quota = Long.parseLong(quotaString);
            this.quotaWarning = Long.parseLong(quotaWarningString);
            this.storageUsage = Long.parseLong(storageUsageString);
            this.latch.countDown();
        }
    }

    private class StorageTotalsMessageListener
    extends TempTopicMessagingListenerBase {
        private CountDownLatch latch;
        private Long usedSpace = null;
        private Long freeSpace = null;

        private StorageTotalsMessageListener() {
        }

        public Long[] query() throws JMSException, InterruptedException {
            this.latch = new CountDownLatch(1);
            try {
                CommandMessage request = new CommandMessage("get-sessions-for-session-name");
                StorageAdminAPI.this.getTopic().sendReplyableMessage(request, this);
                this.latch.await(30L, ServerAdminAPI.TIMEOUT_UNIT);
                if (this.usedSpace != null && this.freeSpace != null) {
                    Long[] longArray = new Long[]{this.usedSpace, this.freeSpace};
                    return longArray;
                }
                Long[] longArray = null;
                return longArray;
            }
            finally {
                this.cleanUp();
            }
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ParameterMessage resultMessage = (ParameterMessage)msg;
            String sizesString = resultMessage.getNamedParameter("size-list");
            String[] sizes = sizesString.split("\t");
            try {
                this.usedSpace = Long.parseLong(sizes[0]);
                this.freeSpace = Long.parseLong(sizes[1]);
            }
            catch (Exception e) {
                this.usedSpace = 0L;
                this.freeSpace = Long.MAX_VALUE;
            }
            this.latch.countDown();
        }
    }

    public static interface StorageEntryListener {
        public void process(List<StorageEntry> var1);
    }
}

