/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.admin;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.JsonMessageListener;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.admin.JobsEntry;
import fi.csc.microarray.messaging.admin.ServerAdminAPI;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.JsonMessage;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class JobmanagerAdminAPI
extends ServerAdminAPI {
    private static final Logger logger = Logger.getLogger(JobmanagerAdminAPI.class);

    public JobmanagerAdminAPI(MessagingEndpoint endpoint) throws IOException, ConfigurationLoader.IllegalConfigurationException, MicroarrayException, JMSException {
        super(Topics.Name.JOBMANAGER_ADMIN_TOPIC, endpoint);
    }

    public HashMap<String, JobsEntry> queryRunningJobs() throws JMSException, InterruptedException, MicroarrayException {
        JsonMessageListener replyListener = new JsonMessageListener();
        CommandMessage request = new CommandMessage("get-running-jobs");
        this.getTopic().sendReplyableMessage(request, replyListener);
        JsonMessage jsonMessage = replyListener.waitForReply(30L, TimeUnit.SECONDS);
        if (jsonMessage != null) {
            String json = jsonMessage.getJson();
            HashMap<String, JobsEntry> jobs = new HashMap<String, JobsEntry>();
            Type listType = new TypeToken<List<HashMap<String, String>>>(){}.getType();
            List mapList = (List)new Gson().fromJson(json, listType);
            for (HashMap map : mapList) {
                JobLogMessage msg = new JobLogMessage();
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    if (map.get(key) != null && !((String)map.get(key)).isEmpty()) continue;
                    iter.remove();
                }
                msg.fromMap(map);
                JobsEntry job = new JobsEntry();
                job.setJobId(msg.getJobId());
                String state = msg.getState().toString();
                if (msg.getStateDetail() != null) {
                    state = state + " (" + msg.getStateDetail() + ")";
                }
                job.setStatus(state);
                job.setStartTime(msg.getStartTime());
                job.setCompHost(msg.getCompHost());
                job.setOperation(msg.getOperation());
                job.setUsername(msg.getUsername());
                jobs.put(msg.getJobId(), job);
            }
            return jobs;
        }
        throw new MicroarrayException("no response from jobmanager about running jobs");
    }

    public void cancelJob(String jobId) throws MicroarrayException {
        try {
            CommandMessage removeRequestMessage = new CommandMessage("cancel");
            removeRequestMessage.addNamedParameter("job-id", jobId);
            this.getTopic().sendMessage(removeRequestMessage);
        }
        catch (JMSException e) {
            logger.error((Object)"cancel job failed", (Throwable)e);
        }
    }

    public void purge() {
        try {
            CommandMessage request = new CommandMessage("purge-old-jobs");
            this.getTopic().sendMessage(request);
        }
        catch (JMSException e) {
            logger.error((Object)"purge old jobs failed", (Throwable)e);
        }
    }

    public static interface JobsListener {
        public void statusUpdated(Collection<JobsEntry> var1);
    }
}

