/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.admin;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.SuccessMessageListener;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.admin.ServerAdminAPI;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import java.io.IOException;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class CompAdminAPI
extends ServerAdminAPI {
    private static final Logger logger = Logger.getLogger(CompAdminAPI.class);

    public CompAdminAPI(MessagingEndpoint endpoint) throws IOException, ConfigurationLoader.IllegalConfigurationException, MicroarrayException, JMSException {
        super(Topics.Name.COMP_ADMIN_TOPIC, endpoint);
    }

    public void stopGracefullyComp(String compId) throws MicroarrayException {
        SuccessMessageListener replyListener = new SuccessMessageListener();
        try {
            CommandMessage removeRequestMessage = new CommandMessage("shutdown-comp");
            removeRequestMessage.addNamedParameter("comp-id", compId);
            this.getTopic().sendReplyableMessage(removeRequestMessage, replyListener);
            SuccessMessage reply = replyListener.waitForReply(30L, TIMEOUT_UNIT);
            this.checkSuccessMessage(reply, "stop comp gracefully");
        }
        catch (JMSException e) {
            logger.error((Object)"stopping comp gracefully failed", (Throwable)e);
        }
    }
}

