/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.QuotaExceededException;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import fi.csc.microarray.messaging.message.UrlMessage;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UrlMessageListener
extends TempTopicMessagingListenerBase {
    private static final Logger logger = Logger.getLogger(UrlMessageListener.class);
    private URL newUrl = null;
    private FileBrokerException exception;
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        if (msg instanceof UrlMessage) {
            UrlMessage urlMessage = (UrlMessage)msg;
            this.newUrl = urlMessage.getUrl();
            this.latch.countDown();
        }
        if (msg instanceof SuccessMessage) {
            SuccessMessage successMessage = (SuccessMessage)msg;
            if ("quota-exceeded".equals(successMessage.getErrorMessage())) {
                this.exception = new QuotaExceededException();
            }
            this.latch.countDown();
        }
        if (msg instanceof CommandMessage) {
            CommandMessage commandMessage = (CommandMessage)msg;
            this.exception = new FileBrokerException(commandMessage.getCommand());
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL waitForReply(long timeout, TimeUnit unit) throws FileBrokerException {
        try {
            this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            logger.warn((Object)"interrupted while waiting for latch", (Throwable)e);
        }
        finally {
            this.cleanUp();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.newUrl;
    }
}

