/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.DirectMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.TempTopicMessagingListener;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import javax.jms.JMSException;
import org.junit.Assert;
import org.junit.Test;

public class DirectMessagingEndpointTest {
    private static final String USERNAME = "authenticated-username";
    private ChipsterMessage receivedMessageTopic1;
    private ChipsterMessage receivedMessageTopic2;
    private ChipsterMessage receivedReplyMessage;

    @Test
    public void test() throws JMSException {
        DirectMessagingEndpoint endpoint = new DirectMessagingEndpoint();
        DirectMessagingEndpoint authenticatingEndpoint = new DirectMessagingEndpoint(USERNAME);
        this.testEndpoint(endpoint, null);
        this.testEndpoint(authenticatingEndpoint, USERNAME);
    }

    public void testEndpoint(MessagingEndpoint endpoint, String username) throws JMSException {
        MessagingTopic topic1 = endpoint.createTopic(Topics.Name.TEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        MessagingTopic topic2 = endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        topic1.setListener(new MessagingListener(){

            @Override
            public void onChipsterMessage(ChipsterMessage msg) {
                DirectMessagingEndpointTest.this.receivedMessageTopic1 = msg;
            }
        });
        topic2.setListener(new MessagingListener(){

            @Override
            public void onChipsterMessage(ChipsterMessage msg) {
                DirectMessagingEndpointTest.this.receivedMessageTopic2 = msg;
            }
        });
        ChipsterMessage message = new ChipsterMessage(){};
        ChipsterMessage replyMessage = new ChipsterMessage(){};
        topic1.sendMessage(message);
        Assert.assertEquals((Object)message.getMessageID(), (Object)this.receivedMessageTopic1.getMessageID());
        Assert.assertNull((Object)this.receivedMessageTopic2);
        Assert.assertEquals((Object)username, (Object)this.receivedMessageTopic1.getUsername());
        ChipsterMessage replyTo = this.receivedMessageTopic1;
        this.receivedMessageTopic1 = null;
        try {
            endpoint.replyToMessage(replyTo, replyMessage);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)this.receivedMessageTopic1);
        Assert.assertNull((Object)this.receivedMessageTopic2);
        Assert.assertNull((Object)this.receivedReplyMessage);
        topic1.sendReplyableMessage(message, new TempTopicMessagingListener(){

            @Override
            public void onChipsterMessage(ChipsterMessage msg) {
                DirectMessagingEndpointTest.this.receivedReplyMessage = msg;
            }

            @Override
            public void setTempTopic(MessagingTopic tempTopic) {
            }

            @Override
            public void cleanUp() {
            }
        });
        Assert.assertEquals((Object)message.getMessageID(), (Object)this.receivedMessageTopic1.getMessageID());
        Assert.assertNull((Object)this.receivedMessageTopic2);
        Assert.assertNull((Object)this.receivedReplyMessage);
        Assert.assertEquals((Object)username, (Object)this.receivedMessageTopic1.getUsername());
        replyTo = this.receivedMessageTopic1;
        this.receivedMessageTopic1 = null;
        endpoint.replyToMessage(replyTo, replyMessage);
        Assert.assertNull((Object)this.receivedMessageTopic1);
        Assert.assertNull((Object)this.receivedMessageTopic2);
        Assert.assertEquals((Object)replyMessage.getMessageID(), (Object)this.receivedReplyMessage.getMessageID());
        Assert.assertEquals((Object)username, (Object)this.receivedReplyMessage.getUsername());
        this.receivedReplyMessage = null;
    }
}

