/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.jobmanager.model;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.jobmanager.HibernateUtil;
import fi.csc.microarray.jobmanager.model.Job;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.jms.Destination;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class JobManagerDB {
    private static Logger logger;
    private HibernateUtil hibernate;
    private Timer purgeOldJobsTimer;
    private int purgeJobsOlderThan;
    private long purgeOldJobsInterval = 0L;

    public JobManagerDB(Configuration configuration) {
        logger = Logger.getLogger(JobManagerDB.class);
        ArrayList hibernateClasses = new ArrayList();
        hibernateClasses.add(Job.class);
        this.hibernate = new HibernateUtil();
        this.hibernate.buildSessionFactory(hibernateClasses, configuration);
        this.purgeOldJobsInterval = configuration.getInt("jobmanager", "purge-jobs-interval");
        this.purgeJobsOlderThan = configuration.getInt("jobmanager", "purge-jobs-older-than");
        logger.info((Object)("check for old jobs every " + this.purgeOldJobsInterval + " hours and purge all jobs older than " + this.purgeJobsOlderThan + " days"));
        logger.info((Object)("there are " + this.getJobCount() + " jobs in the database"));
        if (this.purgeOldJobsInterval > 0L) {
            this.purgeOldJobsTimer = new Timer(true);
            this.purgeOldJobsTimer.schedule((TimerTask)new PurgeOldJobsTask(), this.purgeOldJobsInterval * 60L * 60L * 1000L, this.purgeOldJobsInterval * 60L * 60L * 1000L);
            logger.info((Object)("check for old jobs every " + this.purgeOldJobsInterval + " hours and purge all jobs older than " + this.purgeJobsOlderThan + " days"));
        } else {
            logger.info((Object)"check for old jobs is disabled");
        }
        logger.info((Object)("there are " + this.getJobCount() + " jobs in the database"));
    }

    public boolean addJob(JobMessage jobMessage) {
        String jobId = jobMessage.getJobId();
        if (jobId == null || jobId.isEmpty()) {
            logger.warn((Object)("add job failed, jobId is: " + jobId));
            return false;
        }
        if (this.getJob(jobId) != null) {
            logger.warn((Object)("add job failed, job with id " + jobId + " already exists"));
            return false;
        }
        Job job = new Job(jobMessage);
        job.setReplyTo(jobMessage.getReplyTo());
        this.hibernate.beginTransaction();
        try {
            this.hibernate.session().save((Object)job);
            this.hibernate.commit();
            return true;
        }
        catch (Throwable e) {
            this.hibernate.rollback();
            throw e;
        }
    }

    public Job getJob(String jobId) {
        this.hibernate.beginTransaction();
        try {
            Job job = (Job)this.hibernate.session().get(Job.class, (Serializable)UUID.fromString(jobId));
            this.hibernate.commit();
            return job;
        }
        catch (Throwable e) {
            this.hibernate.rollback();
            throw e;
        }
    }

    public Job updateJob(Job job) {
        this.hibernate.beginTransaction();
        try {
            this.hibernate.session().merge((Object)job);
            this.hibernate.commit();
            return job;
        }
        catch (Throwable e) {
            this.hibernate.rollback();
            throw e;
        }
    }

    public List<Job> getWaitingJobs() {
        this.hibernate.beginTransaction();
        try {
            List jobs = this.hibernate.session().createQuery("from Job where state=:state order by created").setParameter("state", (Object)JobState.WAITING).list();
            this.hibernate.commit();
            return jobs;
        }
        catch (Throwable e) {
            this.hibernate.rollback();
            throw e;
        }
    }

    public List<Job> getRunningJobs() {
        this.hibernate.beginTransaction();
        try {
            List jobs = this.hibernate.session().createQuery("from Job where state=:state1 or state=:state2 order by created").setParameter("state1", (Object)JobState.WAITING).setParameter("state2", (Object)JobState.RUNNING).list();
            this.hibernate.commit();
            return jobs;
        }
        catch (Throwable e) {
            this.hibernate.rollback();
            throw e;
        }
    }

    public boolean updateJobScheduled(Job job, String compId, String compHost) {
        if (job == null) {
            logger.warn((Object)"update scheduled failed: job is null");
            return false;
        }
        if (job.getFinished() != null) {
            logger.warn((Object)String.format("cannot schedule an already finished job %s, state: %s", new Object[]{job.getJobId(), job.getState()}));
            return false;
        }
        job.setState(JobState.SCHEDULED);
        job.setScheduled(new Date());
        job.setCompId(compId);
        job.setCompHost(compHost);
        this.updateJob(job);
        return true;
    }

    public boolean updateJobFinished(Job job, JobState state, ResultMessage results) {
        if (job == null) {
            logger.warn((Object)"update finished failed: job is null");
            return false;
        }
        if (job.getFinished() != null) {
            logger.warn((Object)String.format("cannot finish an already finished job %s, old state: %s, new state: %s", new Object[]{job.getJobId(), job.getState(), state}));
            return false;
        }
        job.setFinished(new Date());
        job.setState(state);
        job.setResults(results);
        this.updateJob(job);
        return true;
    }

    public boolean updateJobRunning(Job job) {
        if (job == null) {
            logger.warn((Object)"update running failed: job is null");
            return false;
        }
        if (job.getFinished() != null) {
            logger.warn((Object)("cannot put a finished job " + job.getJobId() + " to running state"));
            return false;
        }
        job.setSeen(new Date());
        job.setState(JobState.RUNNING);
        this.updateJob(job);
        return true;
    }

    public Job updateJobReplyTo(String jobId, Destination newClientReplyTo) {
        Job job = this.getJob(jobId);
        if (job == null) {
            return null;
        }
        job.setReplyTo((Destination)((ActiveMQTempTopic)newClientReplyTo));
        this.updateJob(job);
        return job;
    }

    public boolean updateJobCancelled(Job job) {
        if (job == null) {
            return false;
        }
        if (job.getFinished() != null) {
            return false;
        }
        job.setState(JobState.CANCELLED);
        job.setFinished(new Date());
        this.updateJob(job);
        return true;
    }

    public void updateJobMaxWaitTimeReached(String jobId) {
        Job job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        job.setState(JobState.EXPIRED_WAITING);
        job.setFinished(new Date());
        this.updateJob(job);
    }

    public void updateJobError(String jobId) {
        Job job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        job.setState(JobState.ERROR);
        this.updateJob(job);
    }

    public boolean updateJobWaiting(String jobId) {
        Job job = this.getJob(jobId);
        if (job == null) {
            logger.warn((Object)("update waiting failed for non-existent job " + jobId));
            return false;
        }
        if (job.getFinished() != null) {
            logger.warn((Object)String.format("cannot put a finished job %s to wait", jobId));
            return false;
        }
        job.setState(JobState.WAITING);
        this.updateJob(job);
        return true;
    }

    public void purgeOldJobs() {
        this.hibernate.beginTransaction();
        try {
            Date purgeDate = new DateTime().minusDays(this.purgeJobsOlderThan).toDate();
            logger.info((Object)("removing jobs older than " + purgeDate));
            int count = this.hibernate.session().createQuery("delete from Job where created < :date ").setParameter("date", (Object)purgeDate).executeUpdate();
            this.hibernate.commit();
            logger.info((Object)("jobs removed: " + count));
        }
        catch (Throwable e) {
            this.hibernate.rollback();
            throw e;
        }
    }

    public Long getJobCount() {
        this.hibernate.beginTransaction();
        try {
            Long count = (Long)this.hibernate.session().createQuery("select count(*) from Job").uniqueResult();
            this.hibernate.commit();
            return count;
        }
        catch (Throwable e) {
            this.hibernate.rollback();
            throw e;
        }
    }

    public class PurgeOldJobsTask
    extends TimerTask {
        @Override
        public void run() {
            JobManagerDB.this.purgeOldJobs();
        }
    }
}

