/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp.java;

import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.microarray.comp.CompException;
import fi.csc.microarray.comp.CompJob;
import fi.csc.microarray.comp.JobFactory;
import fi.csc.microarray.comp.ResultCallback;
import fi.csc.microarray.comp.ToolDescription;
import fi.csc.microarray.comp.ToolDescriptionGenerator;
import fi.csc.microarray.comp.java.JavaCompJobBase;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.messaging.message.GenericJobMessage;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class JavaJobFactory
implements JobFactory {
    static final Logger logger = Logger.getLogger(JavaJobFactory.class);
    private HashMap<String, String> parameters;

    public JavaJobFactory(HashMap<String, String> parameters) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        this.parameters = parameters;
    }

    @Override
    public CompJob createCompJob(GenericJobMessage message, ToolboxTool tool, ResultCallback resultHandler) throws CompException {
        ToolDescription description = this.createToolDescription(tool);
        try {
            Class jobClass = (Class)description.getImplementation();
            JavaCompJobBase analysisJob = (JavaCompJobBase)jobClass.newInstance();
            analysisJob.construct(message, description, resultHandler);
            return analysisJob;
        }
        catch (Exception e) {
            throw new RuntimeException("internal error: type " + description.getImplementation().toString() + " could not be instantiated");
        }
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    private ToolDescription createToolDescription(ToolboxTool tool) throws CompException {
        Class<?> jobClass = null;
        try {
            jobClass = Class.forName(tool.getResourceName());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("could not load job class: " + tool.getResourceName()));
            throw new CompException("could not load job class: " + tool.getResourceName());
        }
        ToolDescription td = new ToolDescriptionGenerator().generate(tool.getSadlDescription());
        td.setImplementation(jobClass);
        td.setCommand("java");
        td.setSourceCode("Source code for this tool is available within Chipster source code.");
        return td;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

