/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.comp.SessionReplayTest;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

class ToolTestResult {
    private SessionReplayTest.TestResult testResult;
    private String taskId;
    private String taskState;
    private String taskErrorMessage;
    private long taskDuration;
    private String toolId;
    private String toolName;
    private String toolFullName;
    private File sessionFile;
    private String testErrorMessage;
    private List<String> outputsWithMisMatchingSizes = new LinkedList<String>();
    private List<String> outputsWithMisMatchingContents = new LinkedList<String>();

    public ToolTestResult(SessionReplayTest.TestResult testResult, String taskId, String taskState, String taskErrorMessage, long taskDuration, String toolId, String toolName, String toolFullName, File sessionFile, String testErrorMessage) {
        this.testResult = testResult;
        this.taskId = taskId;
        this.taskState = taskState;
        this.taskErrorMessage = taskErrorMessage;
        this.taskDuration = taskDuration;
        this.toolId = toolId;
        this.toolName = toolName;
        this.toolFullName = toolFullName;
        this.sessionFile = sessionFile;
        this.testErrorMessage = testErrorMessage;
    }

    public ToolTestResult(SessionReplayTest.TestResult testResult, File sessionFile, Task task, String testErrorMessage) {
        this.testResult = testResult;
        this.taskId = task.getId();
        this.taskState = task.getState().name();
        this.taskErrorMessage = task.getErrorMessage();
        this.taskDuration = task.getExecutionTime();
        this.toolId = task.getOperationID();
        this.toolName = task.getName();
        this.toolFullName = task.getFullName();
        this.sessionFile = sessionFile;
        this.testErrorMessage = testErrorMessage;
    }

    public long getTaskDuration() {
        return this.taskDuration;
    }

    public String getTaskErrorMessage() {
        return this.taskErrorMessage;
    }

    public String getTaskState() {
        return this.taskState;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getToolId() {
        return this.toolId;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getToolFullName() {
        return this.toolFullName;
    }

    public SessionReplayTest.TestResult getTestResult() {
        return this.testResult;
    }

    public File getSession() {
        return this.sessionFile;
    }

    public String getTestErrorMessage() {
        return this.testErrorMessage;
    }

    public List<String> getOutputsWithMisMatchingSizes() {
        return this.outputsWithMisMatchingSizes;
    }

    public void setOutputsWithMisMatchingSizes(List<String> outputs) {
        this.outputsWithMisMatchingSizes = outputs;
    }

    public List<String> getOutputsWithMisMatchingContents() {
        return this.outputsWithMisMatchingContents;
    }

    public void setOutputsWithMisMatchingContents(List<String> outputs) {
        this.outputsWithMisMatchingContents = outputs;
    }
}

