/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import com.beust.jcommander.JCommander;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.RemoteServiceAccessor;
import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.operation.parameter.DataSelectionParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.comp.AnalysisTestBase;
import fi.csc.microarray.comp.SessionReplayTestParameters;
import fi.csc.microarray.comp.ToolTestResult;
import fi.csc.microarray.comp.ToolTestSummary;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataItemBase;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.messaging.MessagingTestBase;
import fi.csc.microarray.module.ModuleManager;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class SessionReplayTest
extends MessagingTestBase {
    public static final String SESSIONS_DIR_NAME = "sessions";
    public static final String SCREEN_OUTPUTS_DIR_NAME = "screen-outputs";
    public static final String STACKTRACES_DIR_NAME = "stacktraces";
    private static final String FLAG_FILE = "test-ok";
    private static final String DEFAULT_WEB_DIR = "web";
    public static final String SCREEN_OUTPUT_POSTFIX = "-output.txt";
    public static final String STACKTRACE_POSTFIX = "-stacktrace.txt";
    private static final long TOOL_TEST_TIMEOUT = 3L;
    private static final TimeUnit TOOL_TEST_TIMEOUT_UNIT = TimeUnit.HOURS;
    private static final boolean FAIL_ON_OUTPUT_SIZE_MISMATCH = false;
    private static final boolean CHECK_CONTENTS = true;
    private File sessionsDir;
    private static File webDir;
    private File screenOutputsDir = new File(webDir, "screen-outputs");
    private File stacktracesDir;
    private TaskExecutor executor;
    private DataManager manager;
    private DataManager sourceManager;
    private ServiceAccessor serviceAccessor;
    LinkedList<ToolModule> toolModules;

    public SessionReplayTest(String username, String password, String configURL) {
        super(username, password, configURL);
        this.screenOutputsDir.mkdirs();
        if (this.screenOutputsDir.exists()) {
            for (File f : this.screenOutputsDir.listFiles()) {
                f.delete();
            }
        }
        this.stacktracesDir = new File(webDir, STACKTRACES_DIR_NAME);
        this.stacktracesDir.mkdirs();
        if (this.stacktracesDir.exists()) {
            for (File f : this.stacktracesDir.listFiles()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testSessions(String sessionsDirName) throws Exception {
        this.sessionsDir = new File(sessionsDirName);
        ToolTestSummary summary = new ToolTestSummary();
        summary.setStartTime(new Date());
        ModuleManager moduleManager = new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule");
        Session.getSession().setModuleManager(moduleManager);
        try {
            this.manager = new DataManager();
            moduleManager.plugAll(this.manager, null);
            this.executor = new TaskExecutor(this.endpoint, this.manager);
            this.toolModules = new LinkedList();
            this.serviceAccessor = new RemoteServiceAccessor();
            this.serviceAccessor.initialise(this.manager, this.authenticationListener);
            this.serviceAccessor.fetchDescriptions(new MicroarrayModule());
            Session.getSession().setServiceAccessor(this.serviceAccessor);
            this.toolModules.addAll(this.serviceAccessor.getModules());
            Session.getSession().setClientApplication(new SessionLoadingSkeletonApplication(this, this.toolModules, this.manager));
            this.sourceManager = new DataManager();
            moduleManager.plugAll(this.sourceManager, null);
            for (File testSession : this.sessionsDir.listFiles()) {
                if (!testSession.getName().endsWith(".zip")) continue;
                this.manager.deleteAllDataItems();
                this.sourceManager.deleteAllDataItems();
                try {
                    this.testSession(testSession, summary);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    File f = this.writeThrowableToDisk(e);
                    summary.getSessionsWithErrors().put(testSession, f.getName());
                }
            }
        }
        finally {
            if (this.serviceAccessor != null) {
                this.serviceAccessor.close();
            }
        }
        this.addAllToolsToSummary(summary);
        summary.calculateStats();
        summary.setEndTime(new Date());
        summary.writeToFiles(webDir);
        return SessionReplayTest.getOverallResult(summary);
    }

    private static boolean getOverallResult(ToolTestSummary summary) {
        boolean combinedToolsResult = true;
        for (ToolTestResult toolTestResult : summary.getToolTestResults()) {
            if (!toolTestResult.getTestResult().equals((Object)TestResult.FAIL)) continue;
            combinedToolsResult = false;
        }
        if (!combinedToolsResult) {
            System.out.println("failed tools, failing");
            return false;
        }
        if (summary.getToolTestResults().size() == 0) {
            System.out.println("zero results, failing");
            return false;
        }
        if (summary.getSessionsWithMissingTools().size() > 0) {
            System.out.println("missing tools, failing");
            return false;
        }
        if (summary.getSessionsWithErrors().size() > 0) {
            System.out.println("sessions with errors, failing");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSession(File session, ToolTestSummary summary) throws Exception {
        HashMap<DataBean, DataBean> sourceDataBeanToTargetDataBean = new HashMap<DataBean, DataBean>();
        Session.getSession().setDataManager(this.sourceManager);
        SessionManager sourceSessionManager = new SessionManager(this.sourceManager, this.serviceAccessor.getTaskExecutor(), this.serviceAccessor.getFileBrokerClient(), null);
        sourceSessionManager.loadLocalSession(session, false);
        Session.getSession().setDataManager(this.manager);
        LinkedList<OperationRecord> rootLevelOperationRecords = new LinkedList<OperationRecord>();
        HashMap<OperationRecord, LinkedList<DataBean>> outputMap = new HashMap<OperationRecord, LinkedList<DataBean>>();
        LinkedList<DataBean> dataBeansInSourceManagerWhichWereCopied = new LinkedList<DataBean>();
        for (DataBean dataBean : this.sourceManager.databeans()) {
            LinkedList<DataBean> outputs;
            OperationRecord operationRecord = dataBean.getOperationRecord();
            if ("operation-definition-id-import".equals(operationRecord.getNameID().getID()) || "LocalNGSPreprocess.java".equals(operationRecord.getNameID().getID()) || dataBean.getLinkTargets(DataBean.Link.derivationalTypes()).size() == 0 && operationRecord.getInputRecords().size() > 0) {
                DataBean dataBeanCopy = this.manager.createDataBean(dataBean.getName());
                URL urlInSessionZip = null;
                for (DataManager.ContentLocation contentLocation : this.sourceManager.getContentLocationsForDataBeanSaving(dataBean)) {
                    if (contentLocation.getMethod() != DataManager.StorageMethod.LOCAL_SESSION_ZIP) continue;
                    urlInSessionZip = contentLocation.getUrl();
                }
                if (urlInSessionZip == null) {
                    throw new IllegalArgumentException("session file " + session.getName() + " must contain all data files (missing " + dataBean.getName() + ")");
                }
                URL url = new URL(session.toURI().toURL(), "#" + urlInSessionZip.getRef());
                this.manager.addContentLocationForDataBean(dataBeanCopy, DataManager.StorageMethod.LOCAL_SESSION_ZIP, url);
                sourceDataBeanToTargetDataBean.put(dataBean, dataBeanCopy);
                dataBeansInSourceManagerWhichWereCopied.add(dataBean);
                dataBeanCopy.setOperationRecord(operationRecord);
                this.manager.connectChild(dataBeanCopy, this.manager.getRootFolder());
                rootLevelOperationRecords.add(operationRecord);
            }
            if ((outputs = (LinkedList<DataBean>)outputMap.get(operationRecord)) != null) {
                outputs.add(dataBean);
                continue;
            }
            outputs = new LinkedList<DataBean>();
            outputs.add(dataBean);
            outputMap.put(operationRecord, outputs);
        }
        for (DataBean originalBean : dataBeansInSourceManagerWhichWereCopied) {
            for (DataBean.Link linkType : DataBean.Link.values()) {
                for (DataBean originalLinkSourceBean : originalBean.getLinkSources(linkType)) {
                    if (!dataBeansInSourceManagerWhichWereCopied.contains(originalLinkSourceBean)) continue;
                    ((DataBean)sourceDataBeanToTargetDataBean.get(originalLinkSourceBean)).addLink(linkType, (DataBean)sourceDataBeanToTargetDataBean.get(originalBean));
                }
            }
        }
        LinkedList<OperationRecord> operationRecords = new LinkedList<OperationRecord>();
        for (DataBean dataBean : this.sourceManager.databeans()) {
            OperationRecord operationRecord = dataBean.getOperationRecord();
            if (operationRecords.contains(operationRecord)) continue;
            operationRecords.add(operationRecord);
        }
        for (OperationRecord operationRecord : operationRecords) {
            if (rootLevelOperationRecords.contains(operationRecord)) {
                System.out.println("skipping root level operation " + operationRecord.getFullName());
                continue;
            }
            System.out.println("setting up " + operationRecord.getFullName());
            LinkedList<DataBean> inputBeans = new LinkedList<DataBean>();
            for (OperationRecord.InputRecord inputRecord : operationRecord.getInputRecords()) {
                DataBean dataBean = (DataBean)sourceDataBeanToTargetDataBean.get(inputRecord.getValue());
                if (dataBean != null) {
                    inputBeans.add(dataBean);
                    continue;
                }
                String s = "not enough inputs for " + operationRecord.getFullName();
                System.out.println(s);
                throw new RuntimeException(s);
            }
            OperationDefinition operationDefinition = this.getOperationDefinition(operationRecord.getNameID().getID(), this.toolModules);
            if (operationDefinition == null) {
                System.out.println("Missing tool: " + operationRecord.getNameID().getID() + "  in session: " + session.getName() + " skipping rest of the session");
                summary.getSessionsWithMissingTools().put(session, operationRecord.getNameID().getID());
                return;
            }
            Operation operation = new Operation(operationDefinition, inputBeans.toArray(new DataBean[0]));
            for (OperationRecord.ParameterRecord parameterRecord : operationRecord.getParameters()) {
                Parameter definitionParameter;
                if (parameterRecord.getValue() == null || parameterRecord.getValue().equals("") || (definitionParameter = operation.getDefinition().getParameter(parameterRecord.getNameID().getID())) == null) continue;
                Parameter parameter = (Parameter)definitionParameter.clone();
                if (parameter instanceof DataSelectionParameter) {
                    ((DataSelectionParameter)parameter).parseValueAndSetWithoutChecks(parameterRecord.getValue());
                } else {
                    parameter.parseValue(parameterRecord.getValue());
                }
                operation.setParameter(parameter.getID(), parameter.getValue());
            }
            Task task = this.executor.createNewTask(new OperationRecord(operation), operation.getDefinition().isLocal());
            System.out.println(new Date() + " running " + operation.getDefinition().getFullName());
            CountDownLatch latch = new CountDownLatch(1);
            task.addTaskEventListener(new AnalysisTestBase.JobResultListener(latch));
            this.executor.startExecuting(task);
            latch.await(3L, TOOL_TEST_TIMEOUT_UNIT);
            this.writeScreenOutputToDisk(task);
            if (!task.getState().equals((Object)Task.State.COMPLETED)) {
                if (task.getState().equals((Object)Task.State.RUNNING)) {
                    this.executor.kill(task);
                    summary.getToolTestResults().add(new ToolTestResult(TestResult.FAIL, session, task, "task did not finish before test timeout 3 " + TOOL_TEST_TIMEOUT_UNIT.toString()));
                    return;
                }
                summary.getToolTestResults().add(new ToolTestResult(TestResult.FAIL, session, task, "task was not completed"));
                return;
            }
            Session.getSession().setDataManager(this.manager);
            try {
                Object targetBean;
                Session.getSession().getApplication().onFinishedTask(task, operation.getResultListener(), task.getState(), true);
                Iterator<DataBean> targetIterator = task.getOutputs().iterator();
                for (DataBean sourceBean : (List)outputMap.get(operationRecord)) {
                    if (targetIterator.hasNext()) {
                        targetBean = targetIterator.next();
                        if (sourceBean.getContentType().getType().equals(((DataBean)targetBean).getContentType().getType())) continue;
                        summary.getToolTestResults().add(new ToolTestResult(TestResult.FAIL, session, task, "Mismatch in result content types, " + sourceBean.getName() + ": " + sourceBean.getContentType().getType() + ", " + ((DataItemBase)targetBean).getName() + ": " + ((DataBean)targetBean).getContentType().getType()));
                        return;
                    }
                    summary.getToolTestResults().add(new ToolTestResult(TestResult.FAIL, session, task, "not enough result datasets"));
                    return;
                }
                if (targetIterator.hasNext()) {
                    summary.getToolTestResults().add(new ToolTestResult(TestResult.FAIL, session, task, "too many result datasets"));
                    return;
                }
                targetIterator = task.getOutputs().iterator();
                for (DataBean sourceBean : (List)outputMap.get(operationRecord)) {
                    targetBean = targetIterator.next();
                    if (!Session.getSession().getPrimaryModule().isMetadata((DataBean)targetBean)) continue;
                    System.out.println("copying metadata for: " + ((DataItemBase)targetBean).getName());
                    OutputStream metadataOut = this.manager.getContentOutputStreamAndLockDataBean((DataBean)targetBean);
                    ChecksumInputStream sourceIn = null;
                    try {
                        sourceIn = this.sourceManager.getContentStream(sourceBean, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);
                        IOUtils.copy((InputStream)sourceIn, metadataOut);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeIfPossible(sourceIn);
                        this.manager.closeContentOutputStreamAndUnlockDataBean((DataBean)targetBean, metadataOut);
                        throw throwable;
                    }
                    IOUtils.closeIfPossible(sourceIn);
                    this.manager.closeContentOutputStreamAndUnlockDataBean((DataBean)targetBean, metadataOut);
                }
                LinkedList<String> outputsWithMisMatchingSizes = new LinkedList<String>();
                LinkedList<String> outputsWithMisMatchingContents = new LinkedList<String>();
                targetIterator = task.getOutputs().iterator();
                for (DataBean sourceBean : (List)outputMap.get(operationRecord)) {
                    ChecksumInputStream targetIn;
                    ChecksumInputStream sourceIn;
                    block41: {
                        DataBean targetBean2 = targetIterator.next();
                        try {
                            this.compareDataBeans(sourceBean, targetBean2);
                        }
                        catch (Throwable t) {
                            summary.getToolTestResults().add(new ToolTestResult(TestResult.FAIL, session, task, t.getMessage()));
                            Session.getSession().setDataManager(null);
                            return;
                        }
                        sourceDataBeanToTargetDataBean.put(sourceBean, targetBean2);
                        if (Session.getSession().getDataManager().getContentLength(sourceBean) != Session.getSession().getDataManager().getContentLength(targetBean2)) {
                            if (sourceBean.getName().equals(targetBean2.getName())) {
                                outputsWithMisMatchingSizes.add(sourceBean.getName());
                            } else {
                                outputsWithMisMatchingSizes.add(sourceBean.getName() + " | " + targetBean2.getName());
                            }
                        }
                        sourceIn = null;
                        targetIn = null;
                        try {
                            sourceIn = this.sourceManager.getContentStream(sourceBean, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);
                            targetIn = this.manager.getContentStream(targetBean2, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);
                            if (IOUtils.contentEquals(sourceIn, targetIn)) break block41;
                            if (sourceBean.getName().equals(targetBean2.getName())) {
                                outputsWithMisMatchingContents.add(sourceBean.getName());
                                break block41;
                            }
                            outputsWithMisMatchingContents.add(sourceBean.getName() + " | " + targetBean2.getName());
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeIfPossible(sourceIn);
                            IOUtils.closeIfPossible(targetIn);
                            throw throwable;
                        }
                    }
                    IOUtils.closeIfPossible(sourceIn);
                    IOUtils.closeIfPossible(targetIn);
                }
                ToolTestResult toolTestResult = new ToolTestResult(TestResult.OK, session, task, null);
                toolTestResult.setOutputsWithMisMatchingSizes(outputsWithMisMatchingSizes);
                toolTestResult.setOutputsWithMisMatchingContents(outputsWithMisMatchingContents);
                summary.getToolTestResults().add(toolTestResult);
            }
            finally {
                Session.getSession().setDataManager(null);
            }
        }
    }

    private OperationDefinition getOperationDefinition(String toolId, LinkedList<ToolModule> toolModules) {
        for (ToolModule module : toolModules) {
            OperationDefinition tool = module.getOperationDefinition(toolId);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    private void compareDataBeans(DataBean bean1, DataBean bean2) {
        Assert.assertEquals((Object)bean1.getContentType().getType(), (Object)bean2.getContentType().getType());
        if (Session.getSession().getDataManager().getContentLength(bean1) > 0L) {
            Assert.assertTrue((String)"zero size dataset", (Session.getSession().getDataManager().getContentLength(bean2) > 0L ? 1 : 0) != 0);
        }
    }

    public static void main(String[] args) throws Exception {
        SessionReplayTestParameters parameters = new SessionReplayTestParameters();
        JCommander jc = new JCommander((Object)parameters);
        SessionReplayTestParameters.CommandRun run = new SessionReplayTestParameters.CommandRun();
        jc.addCommand("run", (Object)run);
        SessionReplayTestParameters.CommandGenerate generate = new SessionReplayTestParameters.CommandGenerate();
        jc.addCommand("generate", (Object)generate);
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            jc.usage();
            SessionReplayTest.initWebDir(null);
            System.out.println("TOOL TEST EARLY ERROR");
            SessionReplayTest.updateFlagFileAndExit(false);
        }
        try {
            if ("run".equals(jc.getParsedCommand())) {
                System.out.println(new Date() + " running session replay test");
                SessionReplayTest.initWebDir(run.output);
                SessionReplayTest.runTestSessions(run.config, run.username, run.password, run.sessions);
            } else if ("generate".equals(jc.getParsedCommand())) {
                SessionReplayTest.initWebDir(generate.output);
                File resultsDir = new File(generate.generateFrom);
                SessionReplayTest.readResultsFromFiles(resultsDir);
            } else {
                jc.usage();
                SessionReplayTest.initWebDir(null);
                SessionReplayTest.updateFlagFileAndExit(false);
            }
        }
        catch (Exception e) {
            System.out.println(Exceptions.getStackTrace(e));
            System.out.println("TOOL TEST EXCEPTION ERROR");
            SessionReplayTest.updateFlagFileAndExit(false);
        }
        System.out.println("TOOL TEST UNEXCPECTED ERROR");
        SessionReplayTest.updateFlagFileAndExit(false);
    }

    private static void initWebDir(String dirName) {
        webDir = dirName == null || dirName.isEmpty() ? new File(DEFAULT_WEB_DIR) : new File(dirName);
        webDir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTestSessions(String config, String username, String password, String sessionsDirName) throws Exception {
        SessionReplayTest test = null;
        try {
            DirectoryLayout.initialiseClientLayout(config);
            test = new SessionReplayTest(username, password, config);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("TOOL TESTS INIT ERROR");
            SessionReplayTest.updateFlagFileAndExit(false);
        }
        try {
            test.setUp();
            boolean testOK = test.testSessions(sessionsDirName);
            test.tearDown();
            if (testOK) {
                System.out.println("TOOL TESTS OK");
                SessionReplayTest.updateFlagFileAndExit(true);
            } else {
                System.out.println("TOOL TESTS FAILED");
                SessionReplayTest.updateFlagFileAndExit(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("TOOL TEST ERROR");
            test.tearDown();
            SessionReplayTest.updateFlagFileAndExit(false);
        }
        finally {
            test.tearDown();
        }
    }

    private static void readResultsFromFiles(File inputDir) throws IOException, ParseException {
        ToolTestSummary summary = new ToolTestSummary();
        summary.readFromFiles(inputDir);
        summary.calculateStats();
        summary.writeToFiles(webDir);
        boolean summaryResult = SessionReplayTest.getOverallResult(summary);
        System.out.println("summary result is : " + summaryResult);
        SessionReplayTest.updateFlagFileAndExit(summaryResult);
    }

    private void writeScreenOutputToDisk(Task task) {
        if (task.getScreenOutput() != null) {
            File outputFile = new File(this.screenOutputsDir, task.getId() + SCREEN_OUTPUT_POSTFIX);
            try {
                IOUtils.copy((InputStream)new ByteArrayInputStream(task.getScreenOutput().getBytes()), outputFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private File writeThrowableToDisk(Throwable t) {
        File outputFile = new File(this.stacktracesDir, UUID.randomUUID().toString() + STACKTRACE_POSTFIX);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(Exceptions.getStackTrace(t).getBytes()), outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return outputFile;
    }

    private static void updateFlagFileAndExit(boolean testOK) throws IOException {
        File flagFile = new File(webDir, FLAG_FILE);
        if (testOK) {
            if (!flagFile.exists()) {
                flagFile.createNewFile();
            } else {
                flagFile.setLastModified(System.currentTimeMillis());
            }
        } else {
            flagFile.delete();
        }
        if (testOK) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private void addAllToolsToSummary(ToolTestSummary summary) {
        for (ToolModule toolModule : this.toolModules) {
            for (ToolCategory toolCategory : toolModule.getVisibleCategories()) {
                for (OperationDefinition od : toolCategory.getToolList()) {
                    summary.getAllTools().put(od.getID(), od.getFullName());
                }
            }
        }
    }

    public static class SessionLoadingSkeletonApplication
    extends ClientApplication {
        private SessionReplayTest parent;

        public SessionLoadingSkeletonApplication(SessionReplayTest parent, LinkedList<ToolModule> toolModules, DataManager manager) {
            this.parent = parent;
            this.toolModules = toolModules;
            this.manager = manager;
            logger = Logger.getLogger(SessionLoadingSkeletonApplication.class);
        }

        @Override
        public OperationDefinition getOperationDefinition(String toolId) {
            return this.parent.getOperationDefinition(toolId, this.toolModules);
        }

        @Override
        public void initialiseGUIThreadSafely(File session) throws MicroarrayException, IOException {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void reportException(Exception e) {
            System.err.println(this.getClass().getSimpleName() + " reporting an exception:");
            e.printStackTrace();
            logger.error((Object)e);
        }

        @Override
        public void reportInitialisationThreadSafely(String report, boolean newline) {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void reportTaskError(Task job) throws MicroarrayException {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void runBlockingTask(String taskName, Runnable runnable) {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal) {
            this.showDialog(title, message, details, severity, modal, ChipsterDialog.DetailsVisibility.DETAILS_VISIBLE, null);
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button) {
            this.showDialog(title, message, details, severity, modal, detailsVisibility, button, false);
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button, boolean feedBackEnabled) {
            System.out.println(title + "\n" + message + "\n" + details);
        }

        @Override
        public void reportExceptionThreadSafely(Exception e) {
            System.err.println(this.getClass().getSimpleName() + " reporting an exception:");
            e.printStackTrace();
            logger.error((Object)e);
        }
    }

    static enum TestResult {
        OK,
        FAIL;

    }
}

