/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.microarray.comp.CompJob;
import fi.csc.microarray.comp.JobCancelledException;
import fi.csc.microarray.comp.ResultCallback;
import fi.csc.microarray.comp.ToolDescription;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.NotEnoughDiskSpaceException;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.GenericJobMessage;
import fi.csc.microarray.security.CryptoKey;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.ToolUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

public abstract class OnDiskCompJobBase
extends CompJob {
    private static final Logger logger = Logger.getLogger(OnDiskCompJobBase.class);
    protected File jobWorkDir;

    @Override
    public void construct(GenericJobMessage inputMessage, ToolDescription toolDescription, ResultCallback resultHandler) {
        super.construct(inputMessage, toolDescription, resultHandler);
        this.jobWorkDir = new File(resultHandler.getWorkDir(), this.getId());
    }

    @Override
    protected void preExecute() throws JobCancelledException {
        this.cancelCheck();
        super.preExecute();
        this.updateStateDetailToClient("transferring input data");
        if (!this.jobWorkDir.mkdir()) {
            this.outputMessage.setErrorMessage("Creating working directory failed.");
            this.updateState(JobState.ERROR, "");
            return;
        }
        try {
            LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>();
            for (String fileName : this.inputMessage.getKeys()) {
                this.cancelCheck();
                String dataId = this.inputMessage.getId(fileName);
                File localFile = new File(this.jobWorkDir, fileName);
                this.resultHandler.getFileBrokerClient().getFile(this.inputMessage.getSessionId(), dataId, new File(this.jobWorkDir, fileName));
                logger.debug((Object)("made available local file: " + localFile.getName() + " " + localFile.length()));
                nameMap.put(fileName, this.inputMessage.getName(fileName));
            }
            ToolUtils.writeInputDescription(new File(this.jobWorkDir, "chipster-inputs.tsv"), nameMap);
            this.inputMessage.preExecute(this.jobWorkDir);
        }
        catch (Exception e) {
            this.outputMessage.setErrorMessage("Transferring input data to computing service failed.");
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.ERROR, "");
            return;
        }
    }

    @Override
    protected void postExecute() throws JobCancelledException {
        this.updateStateDetailToClient("transferring output data");
        this.cancelCheck();
        List<ToolDescription.OutputDescription> outputFiles = this.toolDescription.getOutputFiles();
        for (ToolDescription.OutputDescription fileDescription : outputFiles) {
            File[] describedFiles;
            this.cancelCheck();
            if (fileDescription.getFileName().isSpliced()) {
                String prefix = fileDescription.getFileName().getPrefix();
                String postfix = fileDescription.getFileName().getPostfix();
                String regex = prefix + ".*" + postfix;
                describedFiles = Files.findFiles(this.jobWorkDir, regex);
                if (!fileDescription.isOptional() && describedFiles.length == 0) {
                    logger.error((Object)"required output file set not found");
                    this.outputMessage.setErrorMessage("Required output file set " + fileDescription.getFileName().getID() + " is missing.");
                    this.updateState(JobState.ERROR, "");
                    return;
                }
            } else {
                String outputName = fileDescription.getFileName().getID();
                describedFiles = new File[]{new File(this.jobWorkDir, outputName)};
            }
            String outputsFilename = "chipster-outputs.tsv";
            LinkedHashMap<Object, Object> nameMap = new LinkedHashMap();
            try {
                nameMap = ToolUtils.parseOutputDescription(new File(this.jobWorkDir, outputsFilename));
            }
            catch (MicroarrayException | IOException e) {
                logger.warn((Object)("couldn't parse " + outputsFilename));
                this.outputMessage.setErrorMessage("couldn't parse " + outputsFilename);
                this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
                this.updateState(JobState.ERROR, "");
            }
            for (File outputFile : describedFiles) {
                String dataId = CryptoKey.generateRandom();
                try {
                    String nameInClient = (String)nameMap.get(outputFile.getName());
                    String nameInSessionDb = nameInClient != null ? nameInClient : outputFile.getName();
                    this.resultHandler.getFileBrokerClient().addFile(UUID.fromString(this.inputMessage.getJobId()), this.inputMessage.getSessionId(), dataId, FileBrokerClient.FileBrokerArea.CACHE, outputFile, null, nameInSessionDb);
                    this.outputMessage.addDataset(outputFile.getName(), dataId, nameInClient);
                    logger.debug((Object)("transferred output file: " + fileDescription.getFileName()));
                }
                catch (FileNotFoundException e) {
                    if (fileDescription.isOptional()) continue;
                    logger.error((Object)"required output file not found", (Throwable)e);
                    this.outputMessage.setErrorMessage("Required output file is missing.");
                    this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
                    this.updateState(JobState.ERROR, "");
                    return;
                }
                catch (NotEnoughDiskSpaceException nedse) {
                    logger.warn((Object)"not enough disk space for result file in filebroker");
                    this.outputMessage.setErrorMessage("There was not enough disk space for the result file in the Chipster server. Please try again later.");
                    this.updateState(JobState.FAILED_USER_ERROR, "not enough disk space for results");
                }
                catch (Exception e) {
                    logger.error((Object)"could not put file to file broker", (Throwable)e);
                    this.outputMessage.setErrorMessage("Could not send output file.");
                    this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
                    this.updateState(JobState.ERROR, "");
                    return;
                }
            }
        }
        super.postExecute();
    }

    @Override
    protected void cleanUp() {
        try {
            if (this.resultHandler.shouldSweepWorkDir()) {
                Files.delTree(this.jobWorkDir);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when cleaning up job work dir.", (Throwable)e);
        }
        finally {
            super.cleanUp();
        }
    }
}

