/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.microarray.comp.CompException;
import fi.csc.microarray.comp.CompJob;
import fi.csc.microarray.comp.JobFactory;
import fi.csc.microarray.comp.ProcessPool;
import fi.csc.microarray.comp.ResultCallback;
import fi.csc.microarray.comp.ToolDescription;
import fi.csc.microarray.comp.ToolDescriptionGenerator;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.messaging.message.GenericJobMessage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class InterpreterJobFactory
implements JobFactory {
    static final Logger logger = Logger.getLogger(InterpreterJobFactory.class);
    protected String interpreterCommand;
    protected String toolPath;
    protected String externalToolPath;
    protected ProcessPool processPool;
    protected boolean isDisabled = false;

    public InterpreterJobFactory(HashMap<String, String> parameters) throws IOException {
        String command = parameters.get("command");
        if (command == null || command.equals("")) {
            throw new IllegalArgumentException("Illegal command string: " + command);
        }
        String commandParameters = parameters.get("commandParameters");
        if (commandParameters != null) {
            command = command + " " + commandParameters;
        }
        this.interpreterCommand = command;
        this.toolPath = parameters.get("toolPath");
        this.externalToolPath = parameters.get("externalToolPath");
        if (this.externalToolPath == null) {
            throw new RuntimeException("externalToolPath must be set in runtimes.xml");
        }
        int poolSizeMin = 5;
        int poolSizeMax = 20;
        int poolTimeout = 360;
        int processUseCountMax = 10;
        int processLifetimeMax = 36000;
        try {
            Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
            poolSizeMin = configuration.getInt("comp", "r-process-pool-size-min");
            poolSizeMax = configuration.getInt("comp", "r-process-pool-size-max");
            poolTimeout = configuration.getInt("comp", "r-process-pool-timeout");
            processUseCountMax = configuration.getInt("comp", "r-process-pool-process-use-count-max");
            processLifetimeMax = configuration.getInt("comp", "r-process-pool-process-lifetime-max");
        }
        catch (IllegalStateException e) {
            logger.info((Object)("process pool config missing, using hard coded defaults (" + e.getMessage() + ")"));
        }
        try {
            this.processPool = new ProcessPool(new File(parameters.get("workDir")), this.interpreterCommand, poolSizeMin, poolSizeMax, poolTimeout, processUseCountMax, processLifetimeMax);
        }
        catch (Exception e) {
            logger.warn((Object)("disabling handler " + this.getClass().getSimpleName() + ": " + e.getMessage()));
            this.isDisabled = true;
        }
    }

    @Override
    public abstract CompJob createCompJob(GenericJobMessage var1, ToolboxTool var2, ResultCallback var3) throws CompException;

    protected abstract String getStringDelimeter();

    protected abstract String getVariableNameSeparator();

    protected ToolDescription createToolDescription(ToolboxTool tool) throws CompException {
        File moduleDir = new File(tool.getModule());
        ToolDescription ad = new ToolDescriptionGenerator().generate(tool.getSadlDescription());
        ad.setCommand(this.interpreterCommand);
        ad.setImplementation(tool.getSource());
        ad.setSourceCode(tool.getSource());
        int threadsMax = 2;
        try {
            threadsMax = DirectoryLayout.getInstance().getConfiguration().getInt("comp", "job-threads-max");
        }
        catch (Exception e) {
            logger.info((Object)"could not read job-threads-max from configuration, using defaults");
        }
        int memoryMax = 8192;
        try {
            memoryMax = DirectoryLayout.getInstance().getConfiguration().getInt("comp", "job-memory-max");
        }
        catch (Exception e) {
            logger.info((Object)"could not read job-threads-max from configuration, using defaults");
        }
        File modulesRootDir = new File(System.getProperty("user.dir"), "modules");
        try {
            modulesRootDir = DirectoryLayout.getInstance().getModulesDir();
        }
        catch (IllegalStateException e) {
            logger.info((Object)"modules dir configuration not available, using defaults");
        }
        catch (IOException e) {
            throw new CompException(e);
        }
        File commonScriptDir = new File(modulesRootDir, "common" + this.toolPath);
        String vns = this.getVariableNameSeparator();
        String sd = this.getStringDelimeter();
        ad.setInitialiser("chipster" + vns + "tools" + vns + "path = " + sd + this.externalToolPath + sd + "\n" + "chipster" + vns + "common" + vns + "path = " + sd + commonScriptDir.getAbsolutePath() + sd + "\n" + "chipster" + vns + "module" + vns + "path = " + sd + new File(modulesRootDir, moduleDir.getName()) + sd + "\n" + "chipster" + vns + "threads" + vns + "max = " + sd + threadsMax + sd + "\n" + "chipster" + vns + "memory" + vns + "max = " + sd + memoryMax + sd + "\n");
        return ad;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }
}

