/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.chipster.toolbox.Toolbox;
import fi.csc.chipster.toolbox.ToolboxClient;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.microarray.comp.CompException;
import fi.csc.microarray.comp.CompJob;
import fi.csc.microarray.comp.OldToolboxClient;
import fi.csc.microarray.comp.ResultCallback;
import fi.csc.microarray.comp.RuntimeRepository;
import fi.csc.microarray.comp.ToolRuntime;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.JMSFileBrokerClient;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.GenericJobMessage;
import fi.csc.microarray.messaging.message.GenericResultMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.messaging.message.ParameterMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.messaging.message.ServerStatusMessage;
import fi.csc.microarray.messaging.message.SourceMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.JMSException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class CompServer
extends MonitoredNodeBase
implements MessagingListener,
ResultCallback,
ShutdownCallback {
    public static final String DESCRIPTION_OUTPUT_NAME = "description";
    public static final String SOURCECODE_OUTPUT_NAME = "sourcecode";
    private static Logger logger;
    private static Logger loggerJobs;
    private static Logger loggerStatus;
    private int scheduleTimeout;
    private int offerDelay;
    private int timeoutCheckInterval;
    private int heartbeatInterval;
    private int compAvailableInterval;
    private boolean sweepWorkDir;
    private int maxJobs;
    private String id = UUID.randomUUID().toString();
    private File workDir;
    private RuntimeRepository runtimeRepository;
    private ToolboxClient toolboxClient;
    private Toolbox toolbox;
    private MessagingEndpoint endpoint;
    private MessagingTopic managerTopic;
    private MessagingTopic jobmanagerTopic;
    private FileBrokerClient fileBroker;
    private ExecutorService executorService;
    private Object jobsLock = new Object();
    private LinkedHashMap<String, CompJob> scheduledJobs = new LinkedHashMap();
    private LinkedHashMap<String, CompJob> runningJobs = new LinkedHashMap();
    private Timer timeoutTimer;
    private Timer heartbeatTimer;
    private Timer compAvailableTimer;
    private String localFilebrokerPath;
    private String overridingFilebrokerIp;
    private volatile boolean stopGracefully;

    public CompServer(String configURL) throws Exception {
        DirectoryLayout.initialiseServerLayout(Arrays.asList("comp"), configURL);
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        this.scheduleTimeout = configuration.getInt("comp", "schedule-timeout");
        this.offerDelay = configuration.getInt("comp", "offer-delay");
        this.timeoutCheckInterval = configuration.getInt("comp", "timeout-check-interval");
        this.heartbeatInterval = configuration.getInt("comp", "job-heartbeat-interval");
        this.compAvailableInterval = configuration.getInt("comp", "comp-available-interval");
        this.sweepWorkDir = configuration.getBoolean("comp", "sweep-work-dir");
        this.maxJobs = configuration.getInt("comp", "max-jobs");
        this.localFilebrokerPath = this.nullIfEmpty(configuration.getString("comp", "local-filebroker-user-data-path"));
        this.overridingFilebrokerIp = this.nullIfEmpty(configuration.getString("comp", "overriding-filebroker-ip"));
        logger = Logger.getLogger(CompServer.class);
        loggerJobs = Logger.getLogger((String)"jobs");
        loggerStatus = Logger.getLogger((String)"status");
        logger.info((Object)"starting compute service...");
        this.workDir = DirectoryLayout.getInstance().getJobsDataDirBase(this.id);
        this.executorService = Executors.newCachedThreadPool();
        FileInputStream runtimesStream = new FileInputStream(new File(DirectoryLayout.getInstance().getConfDir(), "runtimes.xml"));
        this.runtimeRepository = new RuntimeRepository(this.workDir, runtimesStream);
        this.toolbox = new Toolbox(DirectoryLayout.getInstance().getModulesDir());
        this.toolboxClient = new OldToolboxClient(this.toolbox);
        this.timeoutTimer = new Timer(true);
        this.timeoutTimer.schedule((TimerTask)new TimeoutTimerTask(), this.timeoutCheckInterval, (long)this.timeoutCheckInterval);
        this.heartbeatTimer = new Timer(true);
        this.compAvailableTimer = new Timer(true);
        this.compAvailableTimer.schedule((TimerTask)new CompAvailableTask(), this.compAvailableInterval, (long)this.compAvailableInterval);
        this.endpoint = new JMSMessagingEndpoint(this);
        MessagingTopic compTopic = this.endpoint.createTopic(Topics.Name.AUTHORIZED_MANAGED_REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        compTopic.setListener(this);
        this.managerTopic = this.endpoint.createTopic(Topics.Name.JOB_LOG_TOPIC, MessagingTopic.AccessMode.WRITE);
        MessagingTopic filebrokerAdminTopic = this.endpoint.createTopic(Topics.Name.COMP_ADMIN_TOPIC, MessagingTopic.AccessMode.READ);
        filebrokerAdminTopic.setListener(new CompAdminMessageListener());
        this.fileBroker = new JMSFileBrokerClient(this.endpoint.createTopic(Topics.Name.AUTHORISED_FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE), this.localFilebrokerPath, this.overridingFilebrokerIp);
        this.jobmanagerTopic = this.endpoint.createTopic(Topics.Name.JOBMANAGER_TOPIC, MessagingTopic.AccessMode.WRITE);
        KeepAliveShutdownHandler.init(this);
        this.sendCompAvailable();
        logger.info((Object)("comp is up and running [" + ApplicationConstants.VERSION + "]"));
        logger.info((Object)("[mem: " + SystemMonitorUtil.getMemInfo() + "]"));
    }

    private String nullIfEmpty(String value) {
        if ("".equals(value.trim())) {
            return null;
        }
        return value;
    }

    @Override
    public String getName() {
        return "comp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChipsterMessage(ChipsterMessage chipsterMessage) {
        if (chipsterMessage.getUsername() == null || chipsterMessage.getUsername().equals("")) {
            logger.warn((Object)"not accepting message with null or empty username");
            try {
                ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Username was null or empty.", "", chipsterMessage.getReplyTo());
                this.sendReplyMessage(chipsterMessage, resultMessage);
            }
            catch (Exception e) {
                logger.warn((Object)"could not send error message for null or empty username");
            }
            return;
        }
        if (chipsterMessage instanceof JobMessage) {
            JobMessage jobMessage = (JobMessage)chipsterMessage;
            this.receiveJob(jobMessage);
        } else if (chipsterMessage instanceof CommandMessage) {
            CommandMessage commandMessage = (CommandMessage)chipsterMessage;
            if ("choose".equals(commandMessage.getCommand())) {
                String acceptedId = commandMessage.getNamedParameter("as-id");
                String jobId = commandMessage.getNamedParameter("job-id");
                logger.debug((Object)("ACCEPT_OFFER for comp: " + acceptedId + " job: " + jobId));
                if (this.id.equals(acceptedId)) {
                    Object object = this.jobsLock;
                    synchronized (object) {
                        CompJob job = this.scheduledJobs.get(commandMessage.getNamedParameter("job-id"));
                        if (job != null) {
                            this.scheduledJobs.remove(jobId);
                            this.runningJobs.put(job.getId(), job);
                            this.executorService.execute(job);
                            logger.info((Object)("Executing job " + job.toolDescription.getDisplayName() + "(" + job.toolDescription.getID() + ")" + ", " + job.getId() + ", " + job.getInputMessage().getUsername()));
                        } else {
                            logger.warn((Object)"Got ACCEPT_OFFER for job which is not scheduled.");
                        }
                    }
                } else {
                    logger.debug((Object)("Removing scheduled job " + jobId));
                    Object job = this.jobsLock;
                    synchronized (job) {
                        if (this.scheduledJobs.containsKey(jobId)) {
                            this.scheduledJobs.remove(jobId);
                            this.activeJobRemoved();
                        }
                    }
                }
            } else {
                if ("describe".equals(commandMessage.getCommand())) {
                    if (this.stopGracefully) {
                        return;
                    }
                    logger.info((Object)"sending all descriptions");
                    try {
                        List<ModuleDescriptionMessage> list = this.createDescriptionsMessages(commandMessage);
                        for (ModuleDescriptionMessage msg : list) {
                            logger.info((Object)("sending descriptions for module " + msg.getModuleName()));
                            this.sendReplyMessage(commandMessage, msg);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"sending descriptions message failed", (Throwable)e);
                    }
                    return;
                }
                if ("get-source".equals(commandMessage.getCommand())) {
                    if (this.stopGracefully) {
                        return;
                    }
                    logger.info((Object)"sending source code");
                    SourceMessage sourceMessage = this.createSourceCodeMessage(commandMessage);
                    if (sourceMessage != null) {
                        this.sendReplyMessage(commandMessage, sourceMessage);
                    }
                    return;
                }
                if ("cancel".equals(commandMessage.getCommand())) {
                    String jobId = commandMessage.getNamedParameter("job-id");
                    this.cancelJob(jobId);
                }
            }
            this.updateStatus();
        } else {
            logger.error((Object)("unidentified message: " + chipsterMessage.getMessageID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelJob(String jobId) {
        CompJob job;
        Object object = this.jobsLock;
        synchronized (object) {
            job = this.scheduledJobs.containsKey(jobId) ? (CompJob)this.scheduledJobs.remove(jobId) : (CompJob)this.runningJobs.remove(jobId);
        }
        if (job != null) {
            job.cancel();
        }
    }

    @Override
    public File getWorkDir() {
        return this.workDir;
    }

    @Override
    public boolean shouldSweepWorkDir() {
        return this.sweepWorkDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRunningJob(CompJob job) {
        String hostname = this.getHost();
        char delimiter = ';';
        try {
            loggerJobs.info((Object)(job.getId() + delimiter + job.getInputMessage().getToolId().replaceAll("\"", "") + delimiter + (Object)((Object)job.getState()) + delimiter + job.getInputMessage().getUsername() + delimiter + job.getExecutionStartTime().toString() + delimiter + job.getExecutionEndTime().toString() + delimiter + hostname));
        }
        catch (Exception e) {
            logger.warn((Object)"got exception when logging a job to be removed", (Throwable)e);
        }
        logger.debug((Object)("comp server removing job " + job.getId() + "(" + (Object)((Object)job.getState()) + ")"));
        Object object = this.jobsLock;
        synchronized (object) {
            this.runningJobs.remove(job.getId());
        }
        this.activeJobRemoved();
        this.sendJobLogMessage(job);
        this.checkStopGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStopGracefully() {
        if (this.stopGracefully) {
            Object object = this.jobsLock;
            synchronized (object) {
                if (this.scheduledJobs.size() == 0 && this.runningJobs.size() == 0) {
                    this.shutdown();
                    System.exit(0);
                }
            }
        }
    }

    public void sendJobLogMessage(CompJob job) {
        JobLogMessage jobLogMessage = this.jobToMessage(job);
        try {
            this.managerTopic.sendMessage(jobLogMessage);
        }
        catch (JMSException e) {
            logger.error((Object)"Could not send job log message.", (Throwable)e);
        }
    }

    private JobLogMessage jobToMessage(CompJob job) {
        String hostname = this.getHost();
        Date startTime = job.getExecutionStartTime();
        if (startTime == null) {
            startTime = job.getScheduleTime();
        }
        if (startTime == null) {
            startTime = job.getReceiveTime();
        }
        JobLogMessage jobLogMessage = new JobLogMessage(job.getInputMessage().getToolId().replaceAll("\"", ""), job.getState(), job.getStateDetail(), job.getId(), startTime, job.getExecutionEndTime(), job.getResultMessage().getErrorMessage(), job.getResultMessage().getOutputText(), job.getInputMessage().getUsername(), hostname);
        return jobLogMessage;
    }

    @Override
    public void sendResultMessage(GenericJobMessage original, GenericResultMessage genericReply) {
        ResultMessage reply = new ResultMessage(genericReply);
        reply.addNamedParameter("as-id", this.id);
        reply.setReplyTo(((JobMessage)original).getReplyTo());
        try {
            this.endpoint.replyToMessage((JobMessage)original, reply);
        }
        catch (JMSException e) {
            logger.error((Object)("Could not send ResultMessage " + reply.getMessageID()));
        }
        logger.info((Object)("result message sent (" + reply.getMessageID() + " " + (Object)((Object)reply.getState()) + ")"));
    }

    @Override
    public FileBrokerClient getFileBrokerClient() {
        return this.fileBroker;
    }

    private void sendReplyMessage(final ChipsterMessage original, final ChipsterMessage reply) {
        if (reply instanceof ResultMessage) {
            ((ResultMessage)reply).addNamedParameter("as-id", this.id);
        }
        reply.setReplyTo(original.getReplyTo());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CompServer.this.endpoint.replyToMessage(original, reply);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private void activeJobRemoved() {
        this.updateStatus();
        this.sendCompAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveJob(GenericJobMessage jobMessage) {
        CompJob job;
        logger.info((Object)("received job request from: " + jobMessage.getUsername()));
        logger.info((Object)("checking if matches guest account: " + DirectoryLayout.getInstance().getConfiguration().getString("security", "guest-username")));
        if (jobMessage.getUsername().equals(DirectoryLayout.getInstance().getConfiguration().getString("security", "guest-username"))) {
            ResultMessage resultMessage = new ResultMessage("", JobState.FAILED_USER_ERROR, "", "Running tools is disabled for guest users.", "", ((JobMessage)jobMessage).getReplyTo());
            this.sendReplyMessage((ChipsterMessage)((Object)jobMessage), resultMessage);
            return;
        }
        if (this.stopGracefully) {
            return;
        }
        ToolboxTool toolboxTool = this.toolboxClient.getTool(jobMessage.getToolId());
        if (toolboxTool == null) {
            return;
        }
        ToolRuntime runtime = this.runtimeRepository.getRuntime(toolboxTool.getRuntime());
        if (runtime == null) {
            logger.warn((Object)String.format("runtime %s for tool %s not found, ignoring job message", toolboxTool.getRuntime(), jobMessage.getToolId()));
            return;
        }
        if (runtime.isDisabled()) {
            logger.warn((Object)String.format("runtime %s for tool %s is disabled, ignoring job message", toolboxTool.getRuntime(), jobMessage.getToolId()));
            return;
        }
        try {
            job = runtime.getJobFactory().createCompJob(jobMessage, toolboxTool, this);
        }
        catch (CompException e) {
            logger.warn((Object)("could not create job for " + jobMessage.getToolId()), (Throwable)e);
            ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Creating job failed", "", ((JobMessage)jobMessage).getReplyTo());
            this.sendReplyMessage((ChipsterMessage)((Object)jobMessage), resultMessage);
            return;
        }
        Object object = this.jobsLock;
        synchronized (object) {
            job.setReceiveTime(new Date());
            if (this.runningJobs.size() + this.scheduledJobs.size() >= this.maxJobs) {
                ResultMessage resultMessage = new ResultMessage(jobMessage.getJobId(), JobState.COMP_BUSY, "", "", "", ((JobMessage)jobMessage).getReplyTo());
                this.sendReplyMessage((ChipsterMessage)((Object)jobMessage), resultMessage);
                return;
            }
            this.scheduleJob(job);
        }
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(final CompJob job) {
        Object object = this.jobsLock;
        synchronized (object) {
            job.setScheduleTime(new Date());
            this.scheduledJobs.put(job.getId(), job);
        }
        try {
            int delay = this.offerDelay * (this.runningJobs.size() + this.scheduledJobs.size() - 1);
            if (delay > 0) {
                Timer timer = new Timer("offer-delay-timer", true);
                timer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            CompServer.this.sendOfferMessage(job);
                        }
                        catch (JMSException e) {
                            Object object = CompServer.this.jobsLock;
                            synchronized (object) {
                                CompServer.this.scheduledJobs.remove(job.getId());
                            }
                            logger.error((Object)("Could not send OFFER for job " + job.getId()));
                        }
                        CompServer.this.updateStatus();
                    }
                }, delay);
            } else {
                this.sendOfferMessage(job);
            }
        }
        catch (Exception e) {
            Object object2 = this.jobsLock;
            synchronized (object2) {
                this.scheduledJobs.remove(job.getId());
            }
            logger.error((Object)("Could not send OFFER for job " + job.getId()));
        }
        this.updateStatus();
    }

    private void sendOfferMessage(CompJob job) throws JMSException {
        CommandMessage offerMessage = new CommandMessage("offer");
        offerMessage.addNamedParameter("as-id", this.id);
        offerMessage.addNamedParameter("job-id", job.getId());
        offerMessage.addNamedParameter("host", this.getHost());
        this.sendReplyMessage((ChipsterMessage)((Object)job.getInputMessage()), offerMessage);
    }

    private List<ModuleDescriptionMessage> createDescriptionsMessages(CommandMessage requestMessage) throws IOException, SAXException, ParserConfigurationException {
        List<ModuleDescriptionMessage> list = this.toolbox.getModuleDescriptions();
        for (ModuleDescriptionMessage descriptionMsg : list) {
            descriptionMsg.setReplyTo(requestMessage.getReplyTo());
        }
        return list;
    }

    private SourceMessage createSourceCodeMessage(CommandMessage requestMessage) {
        String toolID = new String(requestMessage.getParameters().get(0));
        logger.info((Object)("sending source code for " + toolID));
        String sourceCode = this.toolbox.getTool(toolID).getSource();
        if (sourceCode != null) {
            return new SourceMessage(sourceCode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        Object object = this.jobsLock;
        synchronized (object) {
            loggerStatus.info((Object)("scheduled jobs: " + this.scheduledJobs.size() + ", running jobs: " + this.runningJobs.size()));
        }
    }

    private void sendCompAvailable() {
        try {
            this.jobmanagerTopic.sendMessage(new CommandMessage("comp-available"));
        }
        catch (JMSException e) {
            logger.error((Object)"could not send comp available message", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    private synchronized ArrayList<CompJob> getAllJobs() {
        ArrayList<CompJob> allJobs = new ArrayList<CompJob>();
        allJobs.addAll(this.scheduledJobs.values());
        allJobs.addAll(this.runningJobs.values());
        return allJobs;
    }

    private class CompAdminMessageListener
    implements MessagingListener {
        private CompAdminMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            block13: {
                try {
                    if (msg instanceof CommandMessage && "get-comp-status".equals(((CommandMessage)msg).getCommand())) {
                        CommandMessage requestMessage = (CommandMessage)msg;
                        ServerStatusMessage reply = SystemMonitorUtil.getSystemStats(CompServer.this.workDir);
                        if (CompServer.this.stopGracefully) {
                            reply.setStatus("Stopping gracefully...");
                        }
                        reply.setScheduledJobs(CompServer.this.scheduledJobs.size());
                        reply.setRunningJobs(CompServer.this.runningJobs.size());
                        reply.setHost(CompServer.this.getHost());
                        reply.setHostId(CompServer.this.id);
                        CompServer.this.endpoint.replyToMessage(requestMessage, reply);
                        break block13;
                    }
                    if (msg instanceof CommandMessage && "get-running-jobs".equals(((CommandMessage)msg).getCommand())) {
                        CommandMessage requestMessage = (CommandMessage)msg;
                        Object reply = CompServer.this.jobsLock;
                        synchronized (reply) {
                            for (CompJob job : CompServer.this.getAllJobs()) {
                                JobLogMessage reply2 = CompServer.this.jobToMessage(job);
                                CompServer.this.endpoint.replyToMessage(requestMessage, reply2);
                            }
                            break block13;
                        }
                    }
                    if (msg instanceof CommandMessage && "shutdown-comp".equals(((CommandMessage)msg).getCommand())) {
                        CommandMessage requestMessage = (CommandMessage)msg;
                        String compId = ((ParameterMessage)msg).getNamedParameter("comp-id");
                        if (CompServer.this.id.equals(compId)) {
                            CompServer.this.stopGracefully = true;
                            logger.info((Object)"Server received a shutdown request. It will shutdown after all scheduled and running jobs are completed. Scheduling of new jobs is disabled.");
                            SuccessMessage reply = new SuccessMessage(true);
                            CompServer.this.endpoint.replyToMessage(requestMessage, reply);
                            CompServer.this.checkStopGracefully();
                        }
                    } else if (msg instanceof CommandMessage && "cancel".equals(((CommandMessage)msg).getCommand())) {
                        CommandMessage requestMessage = (CommandMessage)msg;
                        String jobId = ((ParameterMessage)msg).getNamedParameter("job-id");
                        logger.info((Object)("Request from CompAdminAPI to cancel a job " + jobId));
                        CompServer.this.cancelJob(jobId);
                        SuccessMessage reply = new SuccessMessage(true);
                        CompServer.this.endpoint.replyToMessage(requestMessage, reply);
                        CompServer.this.updateStatus();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public class CompAvailableTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CompServer.this.jobsLock;
            synchronized (object) {
                if (CompServer.this.runningJobs.size() + CompServer.this.scheduledJobs.size() < CompServer.this.maxJobs) {
                    CompServer.this.sendCompAvailable();
                }
            }
        }
    }

    public class JobHeartbeatTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CompServer.this.jobsLock;
            synchronized (object) {
                for (CompJob job : CompServer.this.getAllJobs()) {
                    job.updateStateToClient();
                }
            }
        }
    }

    private class TimeoutTimerTask
    extends TimerTask {
        private TimeoutTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CompServer.this.jobsLock;
            synchronized (object) {
                ArrayList<CompJob> jobsToBeRemoved = new ArrayList<CompJob>();
                jobsToBeRemoved.clear();
                for (CompJob job : CompServer.this.scheduledJobs.values()) {
                    if (System.currentTimeMillis() - (long)(CompServer.this.scheduleTimeout * 1000) <= job.getScheduleTime().getTime()) break;
                    jobsToBeRemoved.add(job);
                }
                for (CompJob job : jobsToBeRemoved) {
                    CompServer.this.scheduledJobs.remove(job.getId());
                    logger.debug((Object)("Removing old scheduled job: " + job.getId()));
                    CompServer.this.activeJobRemoved();
                }
            }
        }
    }
}

