/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.microarray.comp.JobCancelledException;
import fi.csc.microarray.comp.ResultCallback;
import fi.csc.microarray.comp.ToolDescription;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.GenericJobMessage;
import fi.csc.microarray.messaging.message.GenericResultMessage;
import fi.csc.microarray.util.Exceptions;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class CompJob
implements Runnable {
    public static String SCRIPT_SUCCESSFUL_STRING = "script-finished-succesfully";
    public static String SCRIPT_FAILED_STRING = "script-finished-unsuccesfully";
    public final String CHIPSTER_NOTE_TOKEN = "CHIPSTER-NOTE:";
    private static final Logger logger = Logger.getLogger(CompJob.class);
    protected GenericJobMessage inputMessage;
    protected ResultCallback resultHandler;
    protected ToolDescription toolDescription;
    private Date receiveTime;
    private Date scheduleTime;
    private Date executionStartTime;
    private Date executionEndTime;
    private boolean constructed = false;
    private JobState state = JobState.NEW;
    private String stateDetail = "new job created.";
    private boolean toBeCanceled = false;
    protected GenericResultMessage outputMessage;

    public void construct(GenericJobMessage inputMessage, ToolDescription analysis, ResultCallback resultHandler) {
        this.constructed = true;
        this.toolDescription = analysis;
        this.inputMessage = inputMessage;
        this.resultHandler = resultHandler;
        this.outputMessage = new GenericResultMessage();
        this.outputMessage.setJobId(this.getId());
        this.outputMessage.setState(this.state);
        this.outputMessage.setStateDetail(this.stateDetail);
    }

    @Override
    public void run() {
        try {
            if (!this.constructed) {
                throw new IllegalStateException("you must call construct(...) first");
            }
            this.preExecute();
            if (this.getState() == JobState.RUNNING) {
                this.setExecutionStartTime(new Date());
                this.execute();
                this.setExecutionEndTime(new Date());
            }
            if (this.getState() == JobState.RUNNING) {
                this.postExecute();
            }
            if (this.getState() == JobState.RUNNING) {
                this.state = JobState.COMPLETED;
                this.stateDetail = "";
            }
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail(this.stateDetail);
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
        catch (JobCancelledException jce) {
            this.setExecutionEndTime(new Date());
            logger.debug((Object)("job cancelled: " + this.getId()));
        }
        catch (Throwable e) {
            this.setExecutionEndTime(new Date());
            this.updateState(JobState.ERROR, "running tool failed");
            this.outputMessage.setErrorMessage("Running tool failed.");
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail(this.stateDetail);
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
        finally {
            try {
                this.cleanUp();
            }
            catch (Throwable t) {
                logger.error((Object)"Error when cleaning up.", t);
            }
            this.resultHandler.removeRunningJob(this);
        }
    }

    public String getId() {
        return this.inputMessage.getJobId();
    }

    public synchronized void updateState(JobState newState, String stateDetail) {
        if (this.getState() == JobState.CANCELLED) {
            return;
        }
        this.state = newState;
        this.stateDetail = stateDetail;
    }

    public synchronized void updateStateDetailToClient(String newStateDetail) {
        if (this.getState() == JobState.CANCELLED) {
            return;
        }
        this.stateDetail = newStateDetail;
        this.outputMessage.setState(this.state);
        this.outputMessage.setStateDetail(this.stateDetail);
        this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
    }

    public synchronized void updateStateToClient() {
        this.updateStateToClient(this.state, this.stateDetail, true);
    }

    public synchronized void updateStateToClient(JobState newState, String stateDetail) {
        this.updateStateToClient(newState, stateDetail, false);
    }

    public synchronized void updateStateToClient(JobState newState, String stateDetail, boolean isHeartbeat) {
        if (this.getState() == JobState.CANCELLED) {
            return;
        }
        this.state = newState;
        this.stateDetail = stateDetail;
        this.outputMessage.setState(this.state);
        this.outputMessage.setStateDetail(this.stateDetail);
        this.outputMessage.setHeartbeat(isHeartbeat);
        this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
    }

    public JobState getState() {
        return this.state;
    }

    public void cancel() {
        logger.debug((Object)("Canceling job " + this.getId()));
        this.toBeCanceled = true;
        this.updateState(JobState.CANCELLED, "");
        this.cancelRequested();
    }

    protected void cancelCheck() throws JobCancelledException {
        if (this.toBeCanceled) {
            throw new JobCancelledException();
        }
    }

    protected abstract void cancelRequested();

    protected abstract void execute() throws JobCancelledException;

    protected void preExecute() throws JobCancelledException {
        if (!this.constructed) {
            throw new IllegalStateException("you must call construct(...) first");
        }
        this.updateStateToClient(JobState.RUNNING, "initialising");
    }

    protected void postExecute() throws JobCancelledException {
    }

    protected void cleanUp() {
    }

    public GenericJobMessage getInputMessage() {
        return this.inputMessage;
    }

    public GenericResultMessage getResultMessage() {
        return this.outputMessage;
    }

    public Date getReceiveTime() {
        return this.receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public Date getExecutionEndTime() {
        return this.executionEndTime;
    }

    public void setExecutionEndTime(Date executionEndTime) {
        this.executionEndTime = executionEndTime;
    }

    public String getStateDetail() {
        return this.stateDetail;
    }

    public ToolDescription getToolDescription() {
        return this.toolDescription;
    }
}

