/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;

public class StatusAnimation
extends JComponent
implements DataResultListener {
    private static final long VISIBLE_AFTER = 100L;
    private Map<DataThread, Long> queueLengths = new HashMap<DataThread, Long>();
    private double angle;
    private long previousTime;
    private long hideTime = 0L;
    private QueueManager queueManager;
    private LinkedList<DataThread> dataThreads = new LinkedList();
    private TrackGroup trackGroup;
    private static final int SIZE = 16;
    private static final int THICKNESS = 5;

    public StatusAnimation(QueueManager queueManager, TrackGroup trackGroup) {
        this.queueManager = queueManager;
        this.trackGroup = trackGroup;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean isVisible;
        long queueLength = this.getMaxQueueLength();
        boolean bl = isVisible = !this.trackGroup.isMinimized();
        if (isVisible && queueLength > 0L) {
            if (System.currentTimeMillis() - this.hideTime > 100L) {
                for (double d = 0.0; d < 1.0; d += 0.1) {
                    int radius = 5;
                    double x = Math.sin(this.angle + d * Math.PI * 1.5) * (double)radius;
                    double y = -Math.cos(this.angle + d * Math.PI * 1.5) * (double)radius;
                    this.angle += 0.005 * (double)(System.currentTimeMillis() - this.previousTime);
                    this.previousTime = System.currentTimeMillis();
                    if (this.angle < 0.0) {
                        this.angle += Math.PI * 2;
                    }
                    Color c = GBrowserConstants.COLOR_BLUE;
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(d * 128.0));
                    Ellipse2D.Double circle = new Ellipse2D.Double(x + (double)radius, y + (double)radius, 5.0, 5.0);
                    g.setColor(c);
                    ((Graphics2D)g).fill(circle);
                    this.repaint();
                }
            }
        } else {
            this.hideTime = System.currentTimeMillis();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    private long getMaxQueueLength() {
        long max = 0L;
        for (Long value : this.queueLengths.values()) {
            max = Math.max(max, value);
        }
        return max;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        DataThread dataThread = dataResult.getStatus().getDataThread();
        if (dataResult.getStatus().getDataRequestCount() >= 0L) {
            if (!this.queueLengths.containsKey(dataThread)) {
                this.queueLengths.put(dataThread, 0L);
            }
            Long value = dataResult.getStatus().getDataRequestCount();
            this.queueLengths.put(dataThread, value);
        }
    }

    public void addDataThread(DataThread dataThread) {
        this.dataThreads.add(dataThread);
    }

    public void initilizeListeners() {
        for (DataThread dataThread : this.dataThreads) {
            this.queueManager.addDataResultListener(dataThread, this);
        }
    }

    public void clear() {
        this.dataThreads.clear();
    }
}

