/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cytoband;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class CytobandTrack
extends Track {
    private static final int THICKNESS = 11;
    private static final int MARGIN = 7;
    private SortedSet<Cytoband> cbands = new TreeSet<Cytoband>();
    private boolean showText;
    final Map<Cytoband.Stain, Color> stainColors = new HashMap<Cytoband.Stain, Color>();

    public CytobandTrack(boolean showText) {
        this.stainColors.put(Cytoband.Stain.GNEG, Color.white);
        this.stainColors.put(Cytoband.Stain.GPOS25, Color.lightGray);
        this.stainColors.put(Cytoband.Stain.GPOS33, Color.lightGray);
        this.stainColors.put(Cytoband.Stain.GPOS50, Color.gray);
        this.stainColors.put(Cytoband.Stain.GPOS66, Color.darkGray);
        this.stainColors.put(Cytoband.Stain.GPOS75, Color.darkGray);
        this.stainColors.put(Cytoband.Stain.GPOS100, Color.black);
        this.stainColors.put(Cytoband.Stain.GPOS, Color.black);
        this.stainColors.put(Cytoband.Stain.ACEN, null);
        this.stainColors.put(Cytoband.Stain.GVAR, Color.lightGray);
        this.stainColors.put(Cytoband.Stain.STALK, null);
        this.stainColors.put(Cytoband.Stain.TIP, Color.black);
        this.stainColors.put(Cytoband.Stain.UNRECOGNIZED, null);
        this.showText = showText;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.cbands != null) {
            boolean firstGap = true;
            Iterator cbandIter = this.cbands.iterator();
            while (cbandIter.hasNext()) {
                Cytoband cband = (Cytoband)cbandIter.next();
                if (!this.getView().requestIntersects(cband.getRegion())) {
                    cbandIter.remove();
                    continue;
                }
                Cytoband.Stain stain = cband.getStain();
                Color stainColor = this.stainColors.get((Object)stain);
                String text = cband.getBand();
                if (text == null) {
                    text = "";
                }
                if (stain != null && stainColor != null) {
                    RectDrawable box = this.createDrawable(cband.getRegion().start, cband.getRegion().end, stainColor);
                    drawables.add(box);
                    if (this.showText) {
                        int CHAR_WIDTH = 7;
                        int textSpace = 0;
                        textSpace = box.x >= 0 ? box.width : box.width + box.x;
                        if (textSpace > text.length() * 7) {
                            int textX = Math.max(0, box.x);
                            drawables.add(new TextDrawable(textX, box.y - 2, text, Color.black));
                        }
                    }
                    firstGap = true;
                    continue;
                }
                if (stain == Cytoband.Stain.ACEN) {
                    int y = 8;
                    int sideX = this.getView().bpToTrack(cband.getRegion().end);
                    int cornerX = this.getView().bpToTrack(cband.getRegion().start);
                    if (firstGap) {
                        int tmp = sideX;
                        sideX = cornerX;
                        cornerX = tmp;
                        firstGap = false;
                    }
                    drawables.add(new LineDrawable(sideX, y, cornerX, y + 5, Color.black));
                    drawables.add(new LineDrawable(sideX, y + 11 - 1, cornerX, y + 5, Color.black));
                    continue;
                }
                if (stain != Cytoband.Stain.STALK) continue;
                Rectangle rect = new Rectangle();
                rect.x = this.getView().bpToTrack(cband.getRegion().start);
                rect.width = this.getView().bpToTrack(cband.getRegion().end) - rect.x;
                rect.y = 9;
                rect.height = 6;
                drawables.add(new RectDrawable(rect, Color.gray, Color.gray));
            }
        }
        return drawables;
    }

    private RectDrawable createDrawable(BpCoord startBp, BpCoord endBp, Color c) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp) - 1;
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        rect.y = 7;
        rect.height = 11;
        return new RectDrawable(rect, c, Color.black);
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (Feature content : dataResult.getFeatures()) {
            if (!this.getView().getBpRegion().intersects(content.region)) continue;
            Cytoband cband = (Cytoband)content.values.get((Object)DataType.VALUE);
            this.cbands.add(cband);
        }
    }

    @Override
    public int getTrackHeight() {
        return this.showText ? 40 : 22;
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.VALUE);
    }

    @Override
    public String getTrackName() {
        return "cytoband";
    }
}

