/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cytoband;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CytobandLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.InMemoryIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class CytobandConversion
extends DataThread {
    private Index index;
    private CytobandLineParser parser = new CytobandLineParser();

    public CytobandConversion(DataUrl data, GBrowser browser) {
        super(browser, null);
        try {
            LineDataSource cytobandDataSource = new LineDataSource(data);
            this.index = new InMemoryIndex(cytobandDataSource, this.parser);
            super.setDataSource(cytobandDataSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processDataRequest(DataRequest request) throws InterruptedException {
        if (this.index == null) {
            return;
        }
        try {
            TreeMap<IndexKey, String> lineMap = this.index.getFileLines(request);
            ArrayList<Feature> resultList = new ArrayList<Feature>();
            for (Map.Entry<IndexKey, String> entry : lineMap.entrySet()) {
                LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
                this.parser.setLine(entry.getValue());
                Region region = this.parser.getRegion();
                Cytoband cytoband = new Cytoband(region, this.parser.getBand(), this.parser.getStain());
                values.put(DataType.ID, entry.getKey());
                values.put(DataType.VALUE, cytoband);
                resultList.add(new Feature(region, values));
            }
            super.createDataResult(new DataResult(request.getStatus(), resultList));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
    }
}

