/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.AbstractTsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedLine;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

public class BedLineParser
extends AbstractTsvLineParser {
    private boolean convertCoordinates;

    public BedLineParser(boolean convertCoordinates) {
        this.convertCoordinates = convertCoordinates;
    }

    @Override
    public Region getRegion() {
        if (this.isContentLine()) {
            long start = this.getLong(Column.CHROM_START.ordinal());
            long end = this.getLong(Column.CHROM_END.ordinal());
            Chromosome chr = new Chromosome(this.getString(Column.CHROM.ordinal()));
            if (this.convertCoordinates) {
                ++start;
                ++end;
            }
            return new Region(start, end, chr);
        }
        return null;
    }

    @Override
    public BedLine getFileLine() {
        String string;
        List<Long> rgb;
        BedLine line = new BedLine();
        Region region = this.getRegion();
        line.setChrom(region.start.chr);
        line.setChromStart(region.start.bp);
        line.setChromEnd(region.end.bp);
        int columnCount = this.values.length;
        int column = Column.NAME.ordinal();
        if (columnCount > column) {
            line.setName(this.getString(column));
        }
        if (columnCount > (column = Column.SCORE.ordinal())) {
            line.setScore(this.getFloat(column));
        }
        if (columnCount > (column = Column.SCORE.ordinal())) {
            line.setScore(this.getFloat(column));
        }
        if (columnCount > (column = Column.STRAND.ordinal())) {
            String strandString = this.getString(column);
            if ("+".equals(strandString)) {
                line.setStrand(Strand.FORWARD);
            } else if ("-".equals(strandString)) {
                line.setStrand(Strand.REVERSE);
            }
        }
        if (columnCount > (column = Column.THICK_START.ordinal())) {
            line.setThickStart(this.getLong(column));
        }
        if (columnCount > (column = Column.THICK_END.ordinal())) {
            line.setThickEnd(this.getLong(column));
        }
        if (columnCount > (column = Column.ITEM_RGB.ordinal()) && (rgb = this.splitStringToList(string = this.getString(column))).size() == 3) {
            int r = (int)rgb.get(0).longValue();
            int g = (int)rgb.get(1).longValue();
            int b = (int)rgb.get(2).longValue();
            Color c = new Color(r, g, b);
            line.setItemRgb(c);
        }
        if (columnCount > (column = Column.BLOCK_COUNT.ordinal())) {
            line.setBlockCount(this.getInteger(column));
        }
        if (columnCount > (column = Column.BLOCK_SIZES.ordinal())) {
            string = this.getString(column);
            line.setBlockSizes(this.splitStringToList(string));
        }
        if (columnCount > (column = Column.BLOCK_STARTS.ordinal())) {
            string = this.getString(column);
            line.setBlockStarts(this.splitStringToList(string));
        }
        return line;
    }

    private List<Long> splitStringToList(String string) {
        String[] splitted = string.split(",");
        LinkedList<Long> list = new LinkedList<Long>();
        for (String size : splitted) {
            list.add(Long.parseLong(size));
        }
        return list;
    }

    public int getColumnCount() {
        return this.values.length;
    }

    @Override
    public String getHeaderStart() {
        return "track";
    }

    public static enum Column {
        CHROM("Chromosome"),
        CHROM_START("Start"),
        CHROM_END("End"),
        NAME("Name"),
        SCORE("Score"),
        STRAND("Strand"),
        THICK_START("Thick start"),
        THICK_END("Thick end"),
        ITEM_RGB("Item rgb"),
        BLOCK_COUNT("Block count"),
        BLOCK_SIZES("Block sizes"),
        BLOCK_STARTS("Block starts");

        private final String name;

        private Column(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

