/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.SamBamUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import org.broad.tribble.readers.TabixReader;

public class TabixDataSource
extends DataSource {
    private ChipsterTabixReader reader;

    public TabixDataSource(DataUrl repeat, DataUrl repeatIndex) throws URISyntaxException, IOException {
        super(repeat);
        URL repeatUrl = repeat.getUrl();
        String fileString = null;
        fileString = "http".equals(repeatUrl.getProtocol()) ? repeatUrl.toExternalForm() : new File(repeatUrl.toURI()).getPath();
        this.reader = new ChipsterTabixReader(fileString);
    }

    public void clean() {
        SamBamUtils.closeIfPossible(this.reader);
    }

    public TabixReader.Iterator getTabixIterator(Region request) {
        String chromosome = request.start.chr.toNormalisedString();
        int start = (int)Math.min(Integer.MAX_VALUE, request.start.bp);
        int end = (int)Math.min(Integer.MAX_VALUE, request.end.bp);
        int EXTRA = 500000;
        start = (int)Math.max((long)start - (long)EXTRA, 1L);
        end = (int)Math.min((long)end + (long)EXTRA, Integer.MAX_VALUE);
        int MAX_BIN_SIZE = 0x1FFFFFFE;
        start = Math.min(MAX_BIN_SIZE, start);
        end = Math.min(MAX_BIN_SIZE, end);
        start = Math.max(1, start);
        end = Math.max(1, end);
        String queryRegion = chromosome + ":" + start + "-" + end;
        TabixReader.Iterator iter = null;
        try {
            iter = this.reader.query(queryRegion);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return iter;
    }

    public Set<String> getChromosomes() {
        return this.reader.getChromosomes();
    }

    public static class ChipsterTabixReader
    extends TabixReader {
        public ChipsterTabixReader(String fn) throws IOException {
            super(fn);
        }

        public Set<String> getChromosomes() {
            return this.mChr2tid.keySet();
        }
    }
}

