/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.CoverageTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserSettings;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.BaseStorage;
import fi.csc.microarray.util.BamUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

public class BamToCoverageConversion
extends DataThread {
    private BamDataSource dataSource;
    private GBrowserSettings.CoverageType coverageType;

    public BamToCoverageConversion(BamDataSource file, GBrowserSettings.CoverageType coverageType, GBrowser browser) {
        super(browser, file);
        this.dataSource = file;
        this.coverageType = coverageType;
    }

    @Override
    public void clean() {
        this.dataSource.close();
    }

    @Override
    protected void processDataRequest(DataRequest request) throws InterruptedException {
        long step = 10000L;
        for (long pos = request.start.bp.longValue(); pos < request.end.bp; pos += step) {
            BpCoord from = new BpCoord(pos, request.start.chr);
            BpCoord to = new BpCoord(Math.min(pos + step, request.end.bp), request.start.chr);
            this.calculateCoverage(request, from, to);
        }
    }

    private void calculateCoverage(DataRequest request, BpCoord from, BpCoord to) throws InterruptedException {
        long start = CoverageTool.getBin(from.bp);
        long end = CoverageTool.getBin(to.bp) + 16L - 1L;
        if (end < 1L) {
            end = 1L;
        }
        CloseableIterator<SAMRecord> iterator = this.dataSource.query(from.chr, (int)start, (int)end);
        BaseStorage forwardBaseStorage = new BaseStorage();
        BaseStorage reverseBaseStorage = new BaseStorage();
        while (iterator.hasNext()) {
            SAMRecord record = (SAMRecord)iterator.next();
            LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
            Region recordRegion = new Region(Long.valueOf(record.getAlignmentStart()), Long.valueOf(record.getAlignmentEnd()), request.start.chr);
            Feature read = new Feature(recordRegion, values);
            values.put(DataType.ID, record.getReadName());
            values.put(DataType.STRAND, (Object)BamUtils.getStrand(record, this.coverageType));
            Cigar cigar = new Cigar(read, record.getCigar());
            values.put(DataType.CIGAR, cigar);
            String seq = record.getReadString();
            values.put(DataType.SEQUENCE, seq);
            List<ReadPart> parts = Cigar.splitElements(read);
            for (ReadPart part : parts) {
                if (read.values.get((Object)DataType.STRAND) == Strand.FORWARD) {
                    forwardBaseStorage.addNucleotideCounts(part);
                    continue;
                }
                if (read.values.get((Object)DataType.STRAND) != Strand.REVERSE) continue;
                reverseBaseStorage.addNucleotideCounts(part);
            }
        }
        iterator.close();
        Region filterRegion = new Region(start, end, from.chr);
        forwardBaseStorage.filter(filterRegion);
        reverseBaseStorage.filter(filterRegion);
        LinkedList<Feature> resultList = new LinkedList<Feature>();
        this.createResultList(from, forwardBaseStorage, resultList, Strand.FORWARD);
        this.createResultList(from, reverseBaseStorage, resultList, Strand.REVERSE);
        LinkedList<Feature> averageCoverage = CoverageTool.average(resultList, from.chr);
        if (request.getRequestedContents().contains((Object)DataType.COVERAGE)) {
            super.createDataResult(new DataResult(request, resultList));
        }
        if (request.getRequestedContents().contains((Object)DataType.COVERAGE_AVERAGE)) {
            super.createDataResult(new DataResult(request, averageCoverage));
        }
    }

    private void createResultList(BpCoord from, BaseStorage baseStorage, LinkedList<Feature> resultList, Strand strand) {
        Iterator<BaseStorage.Base> baseIter = baseStorage.iterator();
        while (baseIter.hasNext()) {
            BaseStorage.Base base = baseIter.next();
            Region region = new Region(base.getBpLocation(), base.getBpLocation(), from.chr);
            LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
            values.put(DataType.VALUE, base);
            values.put(DataType.STRAND, (Object)strand);
            resultList.add(new Feature(region, values));
        }
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

