/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import com.jgoodies.looks.HeaderStyle;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.ToolBarComponentFactory;
import fi.csc.microarray.client.visualisation.ComboBoxRenderer;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationMethodRepository;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class VisualisationToolBar
extends JToolBar
implements ActionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(VisualisationToolBar.class);
    public boolean isMaximised = false;
    private SwingClientApplication application = (SwingClientApplication)Session.getSession().getApplication();
    private JButton helpButton = ToolBarComponentFactory.createButton("Help", VisualConstants.QUESTION_MARK_ICON, true, false);
    private JButton maximiseButton = ToolBarComponentFactory.createButton("Maximise", VisualConstants.MAXIMISE_ICON, true, false);
    private JButton detachButton = ToolBarComponentFactory.createButton("Detach", VisualConstants.TO_WINDOW_ICON, true, false);
    private JButton closeButton = ToolBarComponentFactory.createButton("Close", VisualConstants.CLOSE_ICON, true, false);
    JPanel buttonPanel;
    private JComboBox<VisualisationMethod> methodChoiceBox = ToolBarComponentFactory.createComboBox();
    private String helpAddress;
    private boolean userComboAction;

    public VisualisationToolBar() {
        this.setLayout((LayoutManager)new MigLayout("alignx right, height 22!, insets 0"));
        this.setFloatable(false);
        this.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        this.methodChoiceBox.addActionListener(this);
        this.methodChoiceBox.setRenderer(new ComboBoxRenderer());
        String width = "width 100";
        this.add(this.methodChoiceBox, "width 200, pushx, aligny top");
        this.add((Component)this.helpButton, width);
        this.add((Component)this.maximiseButton, width);
        this.add((Component)this.detachButton, width);
        this.add((Component)this.closeButton, width);
        this.helpButton.addActionListener(this);
        this.maximiseButton.addActionListener(this);
        this.detachButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.helpButton.setVisible(false);
        this.refreshVisualisationList(null, null);
        this.application.addClientEventListener(this);
    }

    public Vector<Component> getFocusComponents() {
        Vector<Component> order = new Vector<Component>();
        order.add(this.methodChoiceBox);
        return order;
    }

    public void setHelpAddress(String helpAddress) {
        this.helpAddress = helpAddress;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualisationToolBar.this.helpButton.setVisible(VisualisationToolBar.this.helpAddress != null);
                VisualisationToolBar.this.repaint();
            }
        });
    }

    private void refreshVisualisationList(VisualisationMethod method, List<DataBean> datas) {
        boolean isDefaultMethod = VisualisationMethod.isDefault(method);
        boolean isDatasets = datas != null && datas.size() > 0;
        this.fillMethodsFor(datas);
        this.methodChoiceBox.setEnabled(isDatasets);
        this.maximiseButton.setEnabled(!isDefaultMethod);
        this.methodChoiceBox.setVisible(!isDefaultMethod);
        this.closeButton.setEnabled(!isDefaultMethod);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        VisualisationFrame visualisation = this.application.getVisualisationFrameManager().getFrame(VisualisationFrameManager.FrameType.MAIN);
        if (source == this.methodChoiceBox) {
            if (this.userComboAction) {
                VisualisationMethod method = (VisualisationMethod)this.methodChoiceBox.getSelectedItem();
                if (visualisation.getMethod() != method) {
                    this.application.setVisualisationMethod(method, null, this.application.getSelectionManager().getSelectedDataBeans(), VisualisationFrameManager.FrameType.MAIN);
                }
            }
        } else if (source == this.maximiseButton) {
            this.maximiseOrRestoreVisualisation();
        } else if (source == this.helpButton) {
            this.viewHelp();
        } else if (source == this.detachButton) {
            this.detach();
        } else if (source == this.closeButton) {
            this.application.setVisualisationMethodToDefault();
        }
    }

    public void maximiseOrRestoreVisualisation() {
        this.isMaximised = !this.isMaximised;
        this.application.showMaximisedVisualisation(this.isMaximised);
        this.maximiseButton.setText(this.getMaximiseButtonText());
        this.maximiseButton.setIcon(this.getMaximiseButtonIcon());
    }

    public Icon getMaximiseButtonIcon() {
        return VisualConstants.getIcon(this.isMaximised ? VisualConstants.RESTORE_ICON : VisualConstants.MAXIMISE_ICON);
    }

    public String getMaximiseButtonText() {
        return this.isMaximised ? "Restore" : "Maximise";
    }

    public void viewHelp() {
        this.application.viewHelp(this.helpAddress);
    }

    public void detach() {
        VisualisationFrame visualisation = this.application.getVisualisationFrameManager().getFrame(VisualisationFrameManager.FrameType.MAIN);
        this.application.setVisualisationMethod(visualisation.getMethod(), visualisation.getVariables(), visualisation.getDatas(), VisualisationFrameManager.FrameType.WINDOW);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        VisualisationMethodChangedEvent e;
        if (event instanceof VisualisationMethodChangedEvent && (e = (VisualisationMethodChangedEvent)event).getTarget() == VisualisationFrameManager.FrameType.MAIN) {
            this.setHelpAddress(e.getNewMethod().getHelpAddress());
            this.refreshVisualisationList(e.getNewMethod(), e.getDatas());
            try {
                if (e.getNewMethod() != null) {
                    logger.debug((Object)("updating GUI to method " + e.getNewMethod()));
                    this.userComboAction = false;
                    this.methodChoiceBox.setSelectedItem(e.getNewMethod());
                    this.userComboAction = true;
                    this.methodChoiceBox.repaint();
                }
            }
            catch (Exception exception) {
                this.application.reportException(exception);
            }
        }
    }

    public static List<VisualisationMethod> getMethodsFor(List<DataBean> datas) {
        List<VisualisationMethod> allMethods = Session.getSession().getVisualisations().getVisualisationMethods();
        ArrayList<VisualisationMethod> applicableMethods = new ArrayList<VisualisationMethod>(allMethods);
        ArrayList<VisualisationMethod> emptyList = new ArrayList<VisualisationMethod>();
        if (datas != null) {
            for (VisualisationMethod method : allMethods) {
                try {
                    if (datas.size() == 1) {
                        if (method.isApplicableTo(datas.get(0))) continue;
                        applicableMethods.remove(method);
                        continue;
                    }
                    if (method.isApplicableTo(datas)) continue;
                    applicableMethods.remove(method);
                }
                catch (Exception e) {
                    Session.getSession().getApplication().reportException(new MicroarrayException("Unable to check applicable visualisations for the dataset", e));
                    return emptyList;
                }
            }
        } else {
            return emptyList;
        }
        LinkedList<VisualisationMethod> orderedMethods = new LinkedList<VisualisationMethod>(applicableMethods);
        Collections.sort(orderedMethods, new VisualisationMethodRepository.VisualisationMethodOrderComparator());
        return orderedMethods;
    }

    public void fillMethodsFor(List<DataBean> datas) {
        this.userComboAction = false;
        this.methodChoiceBox.removeAllItems();
        Visualisation.fillComboBox(this.methodChoiceBox, VisualisationToolBar.getMethodsFor(datas).toArray(new VisualisationMethod[0]));
        this.userComboAction = true;
    }
}

